@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  texterra startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Add default JVM options here. You can also use JAVA_OPTS and TEXTERRA_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windows variants

if not "%OS%" == "Windows_NT" goto win9xME_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\texterra-cli.jar;%APP_HOME%\lib\texterra-api-embedded-nlp-models-russian.jar;%APP_HOME%\lib\texterra-api-embedded-nlp-models-generic.jar;%APP_HOME%\lib\texterra-api-embedded-nlp.jar;%APP_HOME%\lib\texterra-api.jar;%APP_HOME%\lib\texterra-tools-nlp-base-models-russian.jar;%APP_HOME%\lib\texterra-tools-nlp-base-models-generic.jar;%APP_HOME%\lib\texterra-tools-nlp-base.jar;%APP_HOME%\lib\texterra-tools-nlp-ne-models-russian.jar;%APP_HOME%\lib\texterra-tools-nlp-ne.jar;%APP_HOME%\lib\texterra-tools-nlp-syntax-models-russian.jar;%APP_HOME%\lib\texterra-tools-nlp-syntax.jar;%APP_HOME%\lib\texterra-tools-nlp.jar;%APP_HOME%\lib\texterra-serializers-json.jar;%APP_HOME%\lib\texterra-core.jar;%APP_HOME%\lib\ml-2.0.12.jar;%APP_HOME%\lib\collections-generic-4.01.jar;%APP_HOME%\lib\commons-io-2.4.jar;%APP_HOME%\lib\commons-configuration-1.9.jar;%APP_HOME%\lib\commons-lang-2.6.jar;%APP_HOME%\lib\commons-lang3-3.2.1.jar;%APP_HOME%\lib\guava-19.0.jar;%APP_HOME%\lib\maltparser-1.9.0.jar;%APP_HOME%\lib\log4j-1.2.17.jar;%APP_HOME%\lib\trove4j-3.0.3.jar;%APP_HOME%\lib\modis-lib-20150204.jar;%APP_HOME%\lib\modis-lib-geo-20150204.jar;%APP_HOME%\lib\argparse4j-0.5.0.jar;%APP_HOME%\lib\jersey-container-grizzly2-http-2.22.1.jar;%APP_HOME%\lib\jersey-server-2.22.1.jar;%APP_HOME%\lib\jersey-client-2.22.1.jar;%APP_HOME%\lib\jersey-media-jaxb-2.22.1.jar;%APP_HOME%\lib\jersey-common-2.22.1.jar;%APP_HOME%\lib\javax.ws.rs-api-2.0.1.jar;%APP_HOME%\lib\javax.servlet-api-3.1.0.jar;%APP_HOME%\lib\simple-xml-2.7.1.jar;%APP_HOME%\lib\commons-jxpath-1.3.jar;%APP_HOME%\lib\jackson-databind-2.7.4.jar;%APP_HOME%\lib\hk2-locator-2.4.0-b31.jar;%APP_HOME%\lib\javax.inject-2.4.0-b31.jar;%APP_HOME%\lib\grizzly-http-server-2.3.23.jar;%APP_HOME%\lib\stax-1.2.0.jar;%APP_HOME%\lib\stax-api-1.0.1.jar;%APP_HOME%\lib\xpp3-1.1.3.3.jar;%APP_HOME%\lib\commons-logging-1.1.1.jar;%APP_HOME%\lib\jackson-annotations-2.7.0.jar;%APP_HOME%\lib\jackson-core-2.7.4.jar;%APP_HOME%\lib\texterra-models-lemmagen-russian-2.0.0.jar;%APP_HOME%\lib\texterra-models-opennlp-sentdetect-russian-1.0.0.jar;%APP_HOME%\lib\texterra-models-opennlp-tokenizer-russian-1.0.0.jar;%APP_HOME%\lib\texterra-models-postagger-russian-4.0.1.jar;%APP_HOME%\lib\texterra-models-bbn-nerc-russian-1.0.0.jar;%APP_HOME%\lib\texterra-models-malt-depparsing-russian-1.0.0.jar;%APP_HOME%\lib\texterra-models-cybozu-langdetect-1.0.0.jar;%APP_HOME%\lib\grizzly-http-2.3.23.jar;%APP_HOME%\lib\javax.annotation-api-1.2.jar;%APP_HOME%\lib\jersey-guava-2.22.1.jar;%APP_HOME%\lib\hk2-api-2.4.0-b31.jar;%APP_HOME%\lib\osgi-resource-locator-1.0.1.jar;%APP_HOME%\lib\validation-api-1.1.0.Final.jar;%APP_HOME%\lib\langdetect-1.1-20120112.jar;%APP_HOME%\lib\opennlp-tools-1.5.3+27e6603369.jar;%APP_HOME%\lib\opennlp-maxent-3.0.3.jar;%APP_HOME%\lib\liblinear-1.92.jar;%APP_HOME%\lib\grizzly-framework-2.3.23.jar;%APP_HOME%\lib\hk2-utils-2.4.0-b31.jar;%APP_HOME%\lib\aopalliance-repackaged-2.4.0-b31.jar;%APP_HOME%\lib\javassist-3.18.1-GA.jar;%APP_HOME%\lib\jsonic-1.2.7.jar;%APP_HOME%\lib\javax.inject-1.jar

@rem Execute texterra
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %TEXTERRA_OPTS%  -classpath "%CLASSPATH%" ru.ispras.texterra.cli.TexterraCLI %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable TEXTERRA_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%TEXTERRA_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
