/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.serializers.json.utils;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import ru.ispras.texterra.core.common.concept.CoordinatesAttribute;
import ru.ispras.texterra.core.common.concept.DefinitionAttribute;
import ru.ispras.texterra.core.common.concept.IAttribute;
import ru.ispras.texterra.core.common.concept.MobileURLAttribute;
import ru.ispras.texterra.core.common.concept.SynonymAttribute;
import ru.ispras.texterra.core.common.concept.TitleAttribute;
import ru.ispras.texterra.core.common.concept.TranslationAttribute;
import ru.ispras.texterra.core.common.concept.TypeAttribute;

public class AttributedConceptConverter {
    public static final Map<String, Class<? extends IAttribute>> attributesShortcuts = ImmutableMap.copyOf(AttributedConceptConverter.getAttributesShortcuts());
    public static final Map<Class<? extends IAttribute>, String> reverseAttributesShortcuts = ImmutableMap.copyOf(attributesShortcuts.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey)));

    private static Map<String, Class<? extends IAttribute>> getAttributesShortcuts() {
        HashMap<String, Class<? extends IAttribute>> result = new HashMap<String, Class<? extends IAttribute>>();
        result.put("coordinates", CoordinatesAttribute.class);
        result.put("definition", DefinitionAttribute.class);
        result.put("url", MobileURLAttribute.class);
        result.put("synonym", SynonymAttribute.class);
        result.put("title", TitleAttribute.class);
        result.put("translation", TranslationAttribute.class);
        result.put("type", TypeAttribute.class);
        return result;
    }

    public static String get(Class<? extends IAttribute> type) {
        return reverseAttributesShortcuts.get(type);
    }

    public static Class<? extends IAttribute> get(String shortcut) {
        return attributesShortcuts.get(shortcut);
    }
}

