/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.serializers.json.jackson.entities;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import ru.ispras.texterra.core.nlp.datamodel.pos.IPOSTag;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.IMorphProperties;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.MorphProperties;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.IMorphCharacter;
import ru.ispras.texterra.serializers.json.jackson.IJacksonSerializer;
import ru.ispras.texterra.serializers.json.jackson.TagSetsJacksonSerializerHelper;

public final class POSTagJacksonSerializer
implements IJacksonSerializer<IMorphProperties> {
    private static final String CHARACTERS = "characters";
    private final TagSetsJacksonSerializerHelper<IPOSTag> posTagsSerializer;
    private final TagSetsJacksonSerializerHelper<IMorphCharacter> morphCharactersSerializer;

    public POSTagJacksonSerializer(TagSetsJacksonSerializerHelper.TagSetsAliases<IPOSTag> posTagsAliases, TagSetsJacksonSerializerHelper.TagSetsAliases<IMorphCharacter> morphCharactersAliases) {
        this.posTagsSerializer = new TagSetsJacksonSerializerHelper<IPOSTag>(posTagsAliases);
        this.morphCharactersSerializer = new TagSetsJacksonSerializerHelper<IMorphCharacter>(morphCharactersAliases);
    }

    @Override
    public void serialize(IMorphProperties posTag, JsonGenerator gen, SerializerProvider provider) throws IOException {
        ObjectMapper mapper = (ObjectMapper)gen.getCodec();
        ObjectNode node = this.morphPropertiesToJson(posTag, mapper);
        gen.writeTree((TreeNode)node);
    }

    private ObjectNode morphPropertiesToJson(IMorphProperties morphProperties, ObjectMapper mapper) {
        ObjectNode node = this.posTagsSerializer.toJson(morphProperties.getPOSTag(), mapper);
        ArrayNode characterNodes = mapper.createArrayNode();
        for (IMorphCharacter morphCharacter : morphProperties.getMorphCharacters()) {
            characterNodes.add((JsonNode)this.morphCharactersSerializer.toJson(morphCharacter, mapper));
        }
        node.set(CHARACTERS, (JsonNode)characterNodes);
        return node;
    }

    @Override
    public IMorphProperties deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectNode node = (ObjectNode)p.readValueAsTree();
        IPOSTag posTag = this.posTagsSerializer.fromJson(node);
        if (!node.has(CHARACTERS)) {
            return new MorphProperties(posTag, new IMorphCharacter[0]);
        }
        ArrayList<IMorphCharacter> morphCharacters = new ArrayList<IMorphCharacter>();
        for (JsonNode characterNode : node.get(CHARACTERS)) {
            morphCharacters.add(this.morphCharactersSerializer.fromJson((ObjectNode)characterNode));
        }
        return new MorphProperties(posTag, morphCharacters);
    }
}

