/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.serializers.json.jackson.entities;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import ru.ispras.texterra.core.common.concept.Concept;
import ru.ispras.texterra.serializers.json.jackson.IJacksonSerializer;

public final class ConceptJacksonSerializer
implements IJacksonSerializer<Concept> {
    private static final String KB_NAME = "kb-name";
    private static final String ID = "id";

    @Override
    public void serialize(Concept concept, JsonGenerator gen, SerializerProvider provider) throws IOException {
        ObjectMapper mapper = (ObjectMapper)gen.getCodec();
        ObjectNode result = mapper.createObjectNode().put(KB_NAME, concept.getKbName()).put(ID, concept.getId());
        gen.writeTree((TreeNode)result);
    }

    @Override
    public Concept deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectNode node = (ObjectNode)p.readValueAsTree();
        return new Concept(node.get(KB_NAME).asText(), node.get(ID).asInt());
    }
}

