/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.serializers.json.jackson.document.entities;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.anaphora.Anaphor;
import ru.ispras.texterra.core.nlp.datamodel.anaphora.Antecedent;
import ru.ispras.texterra.core.nlp.datamodel.anaphora.CoreferenceValue;
import ru.ispras.texterra.core.nlp.datamodel.anaphora.ICoreference;
import ru.ispras.texterra.serializers.json.jackson.document.IJsonConverter;
import ru.ispras.texterra.serializers.json.jackson.document.SpanJsonConverterHelper;

public final class CoreferenceListJsonConverter
implements IJsonConverter<List<ICoreference>> {
    private static final String VALUE = "value";
    private final SpanJsonConverterHelper spanConverter = new SpanJsonConverterHelper();

    @Override
    public List<ICoreference> fromJson(String text, JsonNode node) {
        HashSet<IAnnotation> antecedentSpans = new HashSet<IAnnotation>();
        HashMap<IAnnotation, IAnnotation> anaphorSpans = new HashMap<IAnnotation, IAnnotation>();
        for (JsonNode annotationNode : node) {
            IAnnotation span = this.spanConverter.fromJson(text, (ObjectNode)annotationNode);
            JsonNode valueNode = annotationNode.get(VALUE);
            if (valueNode != null) {
                IAnnotation parentSpan = this.spanConverter.fromJson(text, (ObjectNode)valueNode);
                anaphorSpans.put(span, parentSpan);
                continue;
            }
            antecedentSpans.add(span);
        }
        return this.createCoreferences(antecedentSpans, anaphorSpans);
    }

    private List<ICoreference> createCoreferences(Set<IAnnotation> antecedentSpans, Map<IAnnotation, IAnnotation> anaphorSpans) {
        boolean stop;
        HashMap<IAnnotation, Object> result = new HashMap<IAnnotation, Object>();
        for (IAnnotation antecedentSpan : antecedentSpans) {
            result.put(antecedentSpan, new Antecedent(antecedentSpan));
        }
        do {
            stop = true;
            Iterator<Map.Entry<IAnnotation, IAnnotation>> it = anaphorSpans.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<IAnnotation, IAnnotation> entry = it.next();
                ICoreference antecedent = (ICoreference)result.get(entry.getValue());
                if (antecedent == null) continue;
                IAnnotation anaphorSpan = entry.getKey();
                result.put(anaphorSpan, new Anaphor(anaphorSpan, antecedent));
                it.remove();
                stop = false;
            }
        } while (!stop);
        Validate.isTrue((boolean)anaphorSpans.isEmpty(), (String)"Unresolved spans: %s", (Object[])new Object[]{anaphorSpans.values()});
        return ImmutableList.copyOf(result.values());
    }

    @Override
    public JsonNode toJson(List<ICoreference> annotations) {
        ArrayNode node = JsonNodeFactory.instance.arrayNode();
        for (ICoreference annotation : annotations) {
            ObjectNode annotationNode = this.spanConverter.toJson((IAnnotation)annotation);
            ((CoreferenceValue)annotation.getValue()).getAntecedent().ifPresent(antecedent -> annotationNode.set(VALUE, (JsonNode)this.spanConverter.toJson((IAnnotation)antecedent)));
            node.add((JsonNode)annotationNode);
        }
        return node;
    }
}

