/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.serializers.json.jackson.document;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.Constructor;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.IValuedAnnotation;
import ru.ispras.texterra.serializers.json.jackson.document.IJsonConverter;
import ru.ispras.texterra.serializers.json.jackson.document.SpanJsonConverterHelper;

public final class ValuedAnnotationJsonConverter<VA extends IValuedAnnotation<V>, V>
implements IJsonConverter<VA> {
    private static final String VALUE = "value";
    private final SpanJsonConverterHelper spanConverter = new SpanJsonConverterHelper();
    private final Constructor<VA> constructor;
    private final IJsonConverter<V> valueConverter;

    public ValuedAnnotationJsonConverter(Class<VA> type, Class<V> valueType, IJsonConverter<V> valueConverter) {
        try {
            this.constructor = type.getConstructor(IAnnotation.class, valueType);
            this.valueConverter = valueConverter;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public VA fromJson(String text, JsonNode node) {
        try {
            IAnnotation span = this.spanConverter.fromJson(text, (ObjectNode)node);
            V value = this.valueConverter.fromJson(text, node.get(VALUE));
            return (VA)((IValuedAnnotation)this.constructor.newInstance(span, value));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public JsonNode toJson(VA annotation) {
        ObjectNode result = JsonNodeFactory.instance.objectNode();
        result.setAll(this.spanConverter.toJson((IAnnotation)annotation));
        result.set(VALUE, this.valueConverter.toJson(annotation.getValue()));
        return result;
    }
}

