/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.serializers.json.jackson.document;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.function.Function;
import ru.ispras.texterra.serializers.json.jackson.document.IJsonConverter;

public final class MappingJsonConverter<T1, T2>
implements IJsonConverter<T1> {
    private final IJsonConverter<T2> wrapped;
    private final Function<T2, T1> fromFunction;
    private final Function<T1, T2> toFunction;

    public MappingJsonConverter(IJsonConverter<T2> wrapped, Function<T2, T1> fromFunction, Function<T1, T2> toFunction) {
        this.wrapped = wrapped;
        this.fromFunction = fromFunction;
        this.toFunction = toFunction;
    }

    @Override
    public T1 fromJson(String text, JsonNode node) {
        return this.fromFunction.apply(this.wrapped.fromJson(text, node));
    }

    @Override
    public JsonNode toJson(T1 object) {
        return this.wrapped.toJson(this.toFunction.apply(object));
    }
}

