/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.serializers.json.jackson.document;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import ru.ispras.texterra.serializers.json.jackson.document.IJsonConverter;

public final class JacksonJsonConverter<T>
implements IJsonConverter<T> {
    private final ObjectMapper jackson;
    private final Class<T> type;

    public JacksonJsonConverter(ObjectMapper jackson, Class<T> type) {
        this.jackson = jackson;
        this.type = type;
    }

    @Override
    public T fromJson(String text, JsonNode node) {
        try {
            return (T)this.jackson.treeToValue((TreeNode)node, this.type);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public JsonNode toJson(T object) {
        return this.jackson.valueToTree(object);
    }
}

