/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.serializers.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import ru.ispras.texterra.serializers.json.jackson.IJacksonSerializer;
import ru.ispras.texterra.serializers.json.jackson.TagSetsJacksonSerializerHelper;

public final class TagSetsJacksonSerializer<T>
implements IJacksonSerializer<T> {
    private final TagSetsJacksonSerializerHelper<T> serializer;

    public TagSetsJacksonSerializer(TagSetsJacksonSerializerHelper.TagSetsAliases<T> aliases) {
        this.serializer = new TagSetsJacksonSerializerHelper<T>(aliases);
    }

    @Override
    public void serialize(T tag, JsonGenerator gen, SerializerProvider provider) throws IOException {
        ObjectMapper mapper = (ObjectMapper)gen.getCodec();
        gen.writeTree((TreeNode)this.serializer.toJson(tag, mapper));
    }

    @Override
    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectNode node = (ObjectNode)p.readValueAsTree();
        return this.serializer.fromJson(node);
    }
}

