/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.serializers.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import ru.ispras.texterra.serializers.json.jackson.IJacksonSerializer;

public final class JacksonJsonMapper<T> {
    private final Class<T> type;
    private final IJacksonSerializer<T> serializer;

    public JacksonJsonMapper(Class<T> type, IJacksonSerializer<T> serializer) {
        this.type = type;
        this.serializer = serializer;
    }

    public JsonSerializer<T> getSerializer() {
        return new StdSerializer<T>(this.type){
            private static final long serialVersionUID = 5308276188921089729L;

            public void serialize(T value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                JacksonJsonMapper.this.serializer.serialize(value, gen, provider);
            }
        };
    }

    public JsonDeserializer<T> getDeserializer() {
        return new StdDeserializer<T>(this.type){
            private static final long serialVersionUID = 5870322068475979541L;

            public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                return JacksonJsonMapper.this.serializer.deserialize(p, ctxt);
            }
        };
    }
}

