/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.serializers.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ru.ispras.texterra.core.common.concept.AttributedConcept;
import ru.ispras.texterra.core.common.concept.IAttribute;
import ru.ispras.texterra.serializers.json.datamodel.AttributedConceptSet;
import ru.ispras.texterra.serializers.json.jackson.AttributeValueConverter;
import ru.ispras.texterra.serializers.json.jackson.IJacksonSerializer;
import ru.ispras.texterra.serializers.json.utils.AttributedConceptConverter;
import ru.ispras.texterra.serializers.json.utils.ConceptDelimeterConverter;

public class AttributedConceptSetAsObjectSerializer
implements IJacksonSerializer<AttributedConceptSet> {
    @Override
    public void serialize(AttributedConceptSet value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        for (AttributedConcept attributedConcept : value.getConcepts()) {
            gen.writeFieldName(this.getIdString(attributedConcept));
            this.serialize(attributedConcept.getAllAttributes(), gen);
        }
        gen.writeEndObject();
    }

    private void serialize(List<IAttribute> attributeList, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        Map groupedAttrs = attributeList.stream().collect(Collectors.groupingBy(Object::getClass, Collectors.mapping(AttributeValueConverter::getValue, Collectors.toSet())));
        for (Map.Entry entry : groupedAttrs.entrySet()) {
            gen.writeFieldName(AttributedConceptConverter.get(entry.getKey()));
            gen.writeObject(this.convertAttributeValues(entry.getValue()));
        }
        gen.writeEndObject();
    }

    private Object convertAttributeValues(Set values) {
        switch (values.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return values.iterator().next();
            }
        }
        return values;
    }

    private String getIdString(AttributedConcept attributedConcept) {
        return ConceptDelimeterConverter.stringify(attributedConcept.getConcept());
    }

    @Override
    public AttributedConceptSet deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        throw new UnsupportedOperationException();
    }
}

