/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.geo.lucene.util;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

class FixedTokensCollectionStream
extends TokenStream {
    private final CharTermAttribute charTermAttribute;
    private final String[] indexedValues;
    private int position;

    public FixedTokensCollectionStream(String[] stringArray) {
        this.indexedValues = this.copyAndSort(stringArray);
        this.position = 0;
        this.charTermAttribute = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    }

    private String[] copyAndSort(String[] stringArray) {
        Object[] objectArray = Arrays.copyOf(stringArray, stringArray.length);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public boolean incrementToken() throws IOException {
        if (this.position < this.indexedValues.length) {
            String string = this.indexedValues[this.position];
            ++this.position;
            this.clearAttributes();
            this.charTermAttribute.setEmpty();
            this.charTermAttribute.append(string);
            return true;
        }
        return false;
    }
}

