/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.geo.lucene.grid;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import ru.ispras.modis.geo.Coordinate;
import ru.ispras.modis.geo.lucene.bounding.Rectangle;
import ru.ispras.modis.geo.lucene.grid.BestLevelComputer;
import ru.ispras.modis.geo.lucene.grid.Cell;
import ru.ispras.modis.geo.lucene.project.EquirectangularProjector;
import ru.ispras.modis.geo.lucene.project.IProjector;
import ru.ispras.modis.utils.DoubleUtils;

public class CartesianGridComputer {
    private static final int MIN_LEVEL = 5;
    private static final int MAX_LEVEL = 15;
    private int start;
    private int end;
    private IProjector projector;

    public CartesianGridComputer() {
        this(5, 15, new EquirectangularProjector());
    }

    public CartesianGridComputer(int n, int n2, IProjector iProjector) {
        this.start = n;
        this.end = n2;
        this.projector = iProjector;
    }

    public int getStartLevel() {
        return this.start;
    }

    public int getEndLevel() {
        return this.end;
    }

    public int getBestLevel(double d) {
        int n = BestLevelComputer.getLevelForDistance(d);
        int n2 = Math.max(this.start, n);
        int n3 = Math.min(this.end, n2);
        return n3;
    }

    public Cell getTopRight(Coordinate coordinate, int n) {
        return new CoordinateCellComputer(coordinate, n, this.projector).getTopRight();
    }

    public Cell getBottomLeft(Coordinate coordinate, int n) {
        return new CoordinateCellComputer(coordinate, n, this.projector).getBottomLeft();
    }

    public List<Cell> computeCells(Rectangle rectangle) {
        return this.computeCells(rectangle, this.end);
    }

    public List<Cell> computeCells(Rectangle rectangle, int n) {
        Coordinate coordinate = new Coordinate(rectangle.getBottom(), rectangle.getLeft());
        Cell cell = this.getTopRight(coordinate, n);
        Coordinate coordinate2 = new Coordinate(rectangle.getTop(), rectangle.getRight());
        Cell cell2 = this.getBottomLeft(coordinate2, n);
        int n2 = (int)Math.pow(2.0, n);
        int n3 = cell2.getY() - cell.getY() + 1;
        int n4 = this.computeXDelta(coordinate, cell, coordinate2, cell2, n2);
        return this.collectCells(cell.getX(), cell.getX() + n4, cell.getY(), cell.getY() + n3, n, n2);
    }

    private int computeXDelta(Coordinate coordinate, Cell cell, Coordinate coordinate2, Cell cell2, int n) {
        if (coordinate2.getLongitude() - coordinate.getLongitude() >= 360.0) {
            return n;
        }
        int n2 = cell.getX();
        int n3 = cell2.getX();
        int n4 = n3 - n2;
        if (n4 >= 0) {
            return n4 + 1;
        }
        return n + n4 + 1;
    }

    private List<Cell> collectCells(int n, int n2, int n3, int n4, int n5, int n6) {
        ArrayList<Cell> arrayList = new ArrayList<Cell>();
        if (n >= n2 || n3 >= n4) {
            return arrayList;
        }
        if (n5 <= this.start) {
            this.collectCellsOnLevel(n, n2, n3, n4, n5, n6, arrayList);
            return arrayList;
        }
        if (this.isOddLevel(n)) {
            this.collectCellsOnLevel(n, n + 1, n3, n4, n5, n6, arrayList);
            ++n;
        }
        if (this.isOddLevel(n2)) {
            this.collectCellsOnLevel(n2 - 1, n2, n3, n4, n5, n6, arrayList);
            --n2;
        }
        if (this.isOddLevel(n3)) {
            this.collectCellsOnLevel(n, n2, n3, n3 + 1, n5, n6, arrayList);
            ++n3;
        }
        if (this.isOddLevel(n4)) {
            this.collectCellsOnLevel(n, n2, n4 - 1, n4, n5, n6, arrayList);
            --n4;
        }
        arrayList.addAll(this.collectCells(n / 2, n2 / 2, n3 / 2, n4 / 2, n5 - 1, n6 / 2));
        return arrayList;
    }

    private boolean isOddLevel(int n) {
        return (n & 1) == 1;
    }

    private void collectCellsOnLevel(int n, int n2, int n3, int n4, int n5, int n6, List<Cell> list) {
        for (int i = n; i < n2; ++i) {
            int n7 = i % n6;
            for (int j = n3; j < n4; ++j) {
                list.add(new Cell(n5, n7, j));
            }
        }
    }

    public List<Cell> computeCells(Coordinate coordinate) {
        List<Cell> list = this.computeCells(coordinate, this.end);
        ArrayList<Cell> arrayList = new ArrayList<Cell>(list);
        for (int i = this.end - 1; i >= this.start; --i) {
            list = this.computeParentCells(list);
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public List<Cell> computeCells(Coordinate coordinate, int n) {
        CoordinateCellComputer coordinateCellComputer = new CoordinateCellComputer(coordinate, n, this.projector);
        if (coordinateCellComputer.isSouthOrNorthPole()) {
            return coordinateCellComputer.getAllCellsInRow();
        }
        Cell cell = coordinateCellComputer.getTopRight();
        ArrayList<Cell> arrayList = new ArrayList<Cell>(4);
        arrayList.add(cell);
        if (coordinateCellComputer.isOnMeridian()) {
            arrayList.add(cell.getLeftNeighbour());
        }
        if (coordinateCellComputer.isOnParallel()) {
            ArrayList<Cell> arrayList2 = new ArrayList<Cell>(arrayList.size());
            for (Cell cell2 : arrayList) {
                arrayList2.add(cell2.getBottomNeighbour());
            }
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    private List<Cell> computeParentCells(List<Cell> list) {
        HashSet<Cell> hashSet = new HashSet<Cell>();
        for (Cell cell : list) {
            hashSet.add(cell.getParentCell());
        }
        return new ArrayList<Cell>(hashSet);
    }

    static class CoordinateCellComputer {
        final int numCellsOnLevel;
        final double xUnit;
        final double yUnit;
        final double xTile;
        final double yTile;
        final IProjector.Point point;
        final int level;
        final Coordinate coord;

        public CoordinateCellComputer(Coordinate coordinate, int n, IProjector iProjector) {
            this.numCellsOnLevel = (int)Math.pow(2.0, n);
            this.level = n;
            this.coord = coordinate;
            this.point = iProjector.project(coordinate);
            this.xUnit = 360.0 / (double)this.numCellsOnLevel;
            this.yUnit = 180.0 / (double)this.numCellsOnLevel;
            this.xTile = Math.floor((this.point.getX() + 180.0) / this.xUnit);
            this.yTile = Math.floor((this.point.getY() + 90.0) / this.yUnit);
        }

        public Cell getTopRight() {
            return new Cell(this.level, (int)this.xTile, this.normalize((int)this.yTile, this.numCellsOnLevel));
        }

        private int normalize(int n, int n2) {
            return Math.min(n, n2 - 1);
        }

        public Cell getBottomLeft() {
            Cell cell = this.getTopRight();
            if (this.isSouthOrNorthPole()) {
                if (this.isOnMeridian()) {
                    return cell.getLeftNeighbour();
                }
                return cell;
            }
            Cell cell2 = cell;
            if (this.isOnMeridian()) {
                cell2 = cell2.getLeftNeighbour();
            }
            if (this.isOnParallel()) {
                cell2 = cell2.getBottomNeighbour();
            }
            return cell2;
        }

        private boolean isSouthOrNorthPole() {
            return DoubleUtils.doubleNanoEquals((double)90.0, (double)Math.abs(this.coord.getLatitude()));
        }

        private boolean isOnMeridian() {
            return DoubleUtils.doubleNanoEquals((double)(this.point.getX() + 180.0), (double)(this.xTile * this.xUnit));
        }

        private boolean isOnParallel() {
            return DoubleUtils.doubleNanoEquals((double)(this.point.getY() + 90.0), (double)(this.yTile * this.yUnit));
        }

        public List<Cell> getAllCellsInRow() {
            ArrayList<Cell> arrayList = new ArrayList<Cell>();
            int n = this.normalize((int)this.yTile, this.numCellsOnLevel);
            for (int i = 0; i < this.numCellsOnLevel; ++i) {
                arrayList.add(new Cell(this.level, i, n));
            }
            return arrayList;
        }
    }
}

