/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.geo.lucene.grid;

class BestLevelComputer {
    private static final double cornerBoxScalingCoefficient = 0.5 * (2.0 - Math.sqrt(2.0));
    private static final double naturalLog2 = Math.log(2.0);

    BestLevelComputer() {
    }

    public static int getLevelForDistance(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("metersDistance should be non-negative, received: " + d);
        }
        if (d == 0.0) {
            return Integer.MAX_VALUE;
        }
        double d2 = d * cornerBoxScalingCoefficient;
        double d3 = 4.0075E7 / d2;
        double d4 = Math.ceil(BestLevelComputer.log2(d3));
        return Math.max(1, (int)d4);
    }

    private static double log2(double d) {
        return Math.log(d) / naturalLog2;
    }
}

