/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.geo.lucene.bounding;

import ru.ispras.modis.geo.Coordinate;
import ru.ispras.modis.geo.lucene.bounding.Rectangle;

public class ApproximatingRectanglesComputer {
    public Rectangle getApproximatingRectangle(Coordinate coordinate, double d) {
        double d2;
        double d3;
        double d4;
        double d5 = Math.min(d / 6371009.0, Math.PI);
        double d6 = Math.toDegrees(d5);
        double d7 = Math.min(90.0, coordinate.getLatitude() + d6);
        double d8 = Math.max(-90.0, coordinate.getLatitude() - d6);
        if (this.isSouthOrNorthPole(coordinate)) {
            d4 = 180.0;
        } else {
            d3 = Math.toRadians(coordinate.getLatitude());
            d2 = Math.min(d, this.maxDistanceForLatitude(d3));
            double d9 = this.computeLonDelta(d2 / 6371009.0, d3);
            d4 = Math.toDegrees(d9);
        }
        d3 = coordinate.getLongitude() - d4;
        d2 = coordinate.getLongitude() + d4;
        return new Rectangle(d8, d7, d3, d2);
    }

    private double maxDistanceForLatitude(double d) {
        return 1.2742018E7 * Math.asin(Math.cos(d));
    }

    private boolean isSouthOrNorthPole(Coordinate coordinate) {
        return coordinate.getLatitude() <= -90.0 || coordinate.getLatitude() >= 90.0;
    }

    private double computeLonDelta(double d, double d2) {
        double d3 = Math.cos(d2);
        double d4 = d3 * d3;
        return Math.acos((Math.cos(d) + d4 - 1.0) / d4);
    }
}

