/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.geo.lucene;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.tier.CartesianPolyFilterBuilder;
import org.apache.lucene.spatial.tier.Shape;
import org.apache.lucene.util.NumericUtils;
import ru.ispras.modis.geo.Coordinate;
import ru.ispras.modis.geo.lucene.PreciseDistanceFilter;
import ru.ispras.modis.geo.lucene.SpatialUtils;
import ru.ispras.modis.geo.lucene.TierFieldsComputer;

@Deprecated
public class LocationUtils {
    private static final String LATITUDE = "LATITUDE";
    private static final String LONGITUDE = "LONGITUDE";
    public static final LocationUtils locationUtils = new LocationUtils();
    private String latitudeFieldName;
    private String longitudeFieldName;
    private TierFieldsComputer tierComputer;
    private FieldSelector selector;

    public LocationUtils() {
        this(LATITUDE, LONGITUDE, TierFieldsComputer.tierFieldsComputer);
    }

    public LocationUtils(String string, String string2, TierFieldsComputer tierFieldsComputer) {
        this.latitudeFieldName = string;
        this.longitudeFieldName = string2;
        this.tierComputer = tierFieldsComputer;
        this.selector = this.createFieldSelector();
    }

    private FieldSelector createFieldSelector() {
        return new FieldSelector(){
            private static final long serialVersionUID = -8123845381824433511L;

            public FieldSelectorResult accept(String string) {
                if (string.equals(LocationUtils.this.latitudeFieldName) || string.equals(LocationUtils.this.longitudeFieldName)) {
                    return FieldSelectorResult.LOAD;
                }
                return FieldSelectorResult.NO_LOAD;
            }
        };
    }

    public FieldSelector getCoordinateFieldsSelector() {
        return this.selector;
    }

    public Coordinate extractCoordinate(Document document) {
        return new Coordinate(NumericUtils.prefixCodedToDouble((String)document.get(this.latitudeFieldName)), NumericUtils.prefixCodedToDouble((String)document.get(this.longitudeFieldName)));
    }

    public Document addCoordinateFields(Document document, Coordinate coordinate) {
        document.add((Fieldable)new Field(this.latitudeFieldName, NumericUtils.doubleToPrefixCoded((double)coordinate.getLatitude()), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        document.add((Fieldable)new Field(this.longitudeFieldName, NumericUtils.doubleToPrefixCoded((double)coordinate.getLongitude()), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        for (Fieldable fieldable : this.tierComputer.getTierFields(coordinate)) {
            document.add(fieldable);
        }
        return document;
    }

    public Query makeDistanceQuery(Coordinate coordinate, double d, boolean bl) {
        return new ConstantScoreQuery(this.makeDistanceFilter(coordinate, d, bl));
    }

    public Query makeDistanceQuery(Coordinate coordinate, double d) {
        return this.makeDistanceQuery(coordinate, d, true);
    }

    public Filter makeDistanceFilter(Coordinate coordinate, double d, boolean bl) {
        CartesianPolyFilterBuilder cartesianPolyFilterBuilder = new CartesianPolyFilterBuilder(this.tierComputer.getTierPrefix(), this.tierComputer.getStartTier(), this.tierComputer.getEndTier());
        if (bl) {
            Shape shape = cartesianPolyFilterBuilder.getBoxShape(coordinate.getLatitude(), coordinate.getLongitude(), SpatialUtils.metersToMiles(d));
            return new PreciseDistanceFilter(coordinate, d, this.getBoxIds(shape), shape.getTierId()){
                private static final long serialVersionUID = 4411082237520266741L;

                @Override
                protected Collection<Coordinate> getCoordinates(int n, IndexReader indexReader) throws IOException {
                    Document document = indexReader.document(n, LocationUtils.this.getCoordinateFieldsSelector());
                    Coordinate coordinate = LocationUtils.this.extractCoordinate(document);
                    return Collections.singletonList(coordinate);
                }
            };
        }
        return cartesianPolyFilterBuilder.getBoundingArea(coordinate.getLatitude(), coordinate.getLongitude(), SpatialUtils.metersToMiles(d));
    }

    private String[] getBoxIds(Shape shape) {
        List list = shape.getArea();
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = NumericUtils.doubleToPrefixCoded((double)((Double)list.get(i)));
        }
        return stringArray;
    }
}

