/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.serializers.json.jackson.document.entities;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import ru.ispras.texterra.core.nlp.datamodel.IToken;
import ru.ispras.texterra.core.nlp.datamodel.Token;
import ru.ispras.texterra.core.nlp.datamodel.syntax.ISyntaxRelationValue;
import ru.ispras.texterra.core.nlp.datamodel.syntax.RootSyntaxRelationValue;
import ru.ispras.texterra.core.nlp.datamodel.syntax.SyntaxRelationValue;
import ru.ispras.texterra.serializers.json.jackson.document.IJsonConverter;

public final class SyntaxRelationValueJsonConverter
implements IJsonConverter<ISyntaxRelationValue> {
    private static final String PARENT = "parent";
    private static final String TYPE = "type";
    private final IJsonConverter<Token> tokenConverter;

    public SyntaxRelationValueJsonConverter(IJsonConverter<Token> tokenConverter) {
        this.tokenConverter = tokenConverter;
    }

    @Override
    public ISyntaxRelationValue fromJson(String text, JsonNode node) {
        ObjectNode objectNode = (ObjectNode)node;
        if (objectNode.size() == 0) {
            return new RootSyntaxRelationValue();
        }
        IToken parent = (IToken)this.tokenConverter.fromJson(text, objectNode.get(PARENT));
        String type = objectNode.get(TYPE).asText();
        return new SyntaxRelationValue(parent, type);
    }

    @Override
    public JsonNode toJson(ISyntaxRelationValue syntaxRelation) {
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        if (syntaxRelation instanceof RootSyntaxRelationValue) {
            return node;
        }
        node.set(PARENT, this.tokenConverter.toJson((Token)syntaxRelation.getParentToken()));
        node.put(TYPE, syntaxRelation.getRelationType());
        return node;
    }
}

