/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.serializers.json.jackson.document.entities;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import ru.ispras.texterra.core.common.concept.Concept;
import ru.ispras.texterra.core.nlp.datamodel.ConceptOccurrences;
import ru.ispras.texterra.core.nlp.datamodel.DisambiguatedPhrase;
import ru.ispras.texterra.serializers.json.jackson.document.IJsonConverter;

public final class ConceptOccurrencesValueJsonConverter
implements IJsonConverter<ConceptOccurrences.ConceptOccurrencesValue> {
    private static final String CONCEPT = "concept";
    private static final String OCCURRENCES = "occurrences";
    private final IJsonConverter<Concept> conceptConverter;
    private final IJsonConverter<DisambiguatedPhrase> occurrenceConverter;

    public ConceptOccurrencesValueJsonConverter(IJsonConverter<Concept> conceptConverter, IJsonConverter<DisambiguatedPhrase> occurrenceConverter) {
        this.conceptConverter = conceptConverter;
        this.occurrenceConverter = occurrenceConverter;
    }

    @Override
    public ConceptOccurrences.ConceptOccurrencesValue fromJson(String text, JsonNode node) {
        ObjectNode objectNode = (ObjectNode)node;
        Concept concept = this.conceptConverter.fromJson(text, objectNode.get(CONCEPT));
        ArrayList<DisambiguatedPhrase> occurrences = new ArrayList<DisambiguatedPhrase>();
        for (JsonNode occurrenceNode : objectNode.get(OCCURRENCES)) {
            occurrences.add(this.occurrenceConverter.fromJson(text, occurrenceNode));
        }
        return new ConceptOccurrences.ConceptOccurrencesValue(concept, occurrences);
    }

    @Override
    public JsonNode toJson(ConceptOccurrences.ConceptOccurrencesValue conceptOccurrences) {
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        node.set(CONCEPT, this.conceptConverter.toJson(conceptOccurrences.getConcept()));
        ArrayNode occurrencesNode = JsonNodeFactory.instance.arrayNode();
        for (DisambiguatedPhrase occurrence : conceptOccurrences.getOccurrences()) {
            occurrencesNode.add(this.occurrenceConverter.toJson(occurrence));
        }
        node.set(OCCURRENCES, (JsonNode)occurrencesNode);
        return node;
    }
}

