/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.serializers.json.jackson.document;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.IValuedAnnotation;
import ru.ispras.texterra.core.nlp.factories.DefaultDocumentFactory;
import ru.ispras.texterra.core.nlp.factories.IDocumentFactory;
import ru.ispras.texterra.serializers.json.jackson.IJacksonSerializer;
import ru.ispras.texterra.serializers.json.jackson.document.AnnotationJsonConverter;
import ru.ispras.texterra.serializers.json.jackson.document.IJsonConverter;
import ru.ispras.texterra.serializers.json.jackson.document.JacksonJsonConverter;
import ru.ispras.texterra.serializers.json.jackson.document.ListJsonConverter;
import ru.ispras.texterra.serializers.json.jackson.document.ValuedAnnotationJsonConverter;

public final class NLPDocumentJacksonSerializer
implements IJacksonSerializer<INLPDocument> {
    private static final String TEXT_FIELD = "text";
    private static final String ANNOTATIONS_FIELD = "annotations";
    private final AnnotationTypesAliases aliases;
    private final Function<Class<? extends IAnnotation>, Class<? extends IAnnotation>> typeMapper;
    private final IDocumentFactory factory;

    public NLPDocumentJacksonSerializer(AnnotationTypesAliases aliases) {
        this(aliases, Function.identity());
    }

    public NLPDocumentJacksonSerializer(AnnotationTypesAliases aliases, Function<Class<? extends IAnnotation>, Class<? extends IAnnotation>> typeMapper) {
        this(aliases, typeMapper, (IDocumentFactory)new DefaultDocumentFactory());
    }

    public NLPDocumentJacksonSerializer(AnnotationTypesAliases aliases, Function<Class<? extends IAnnotation>, Class<? extends IAnnotation>> typeMapper, IDocumentFactory factory) {
        this.aliases = aliases;
        this.typeMapper = typeMapper;
        this.factory = factory;
    }

    @Override
    public void serialize(INLPDocument doc, JsonGenerator gen, SerializerProvider provider) throws IOException {
        ObjectMapper mapper = (ObjectMapper)gen.getCodec();
        ObjectNode annotationsNode = mapper.createObjectNode();
        Map<Class, List<IAnnotation>> annotations = doc.getAnnotations(IAnnotation.class).stream().collect(Collectors.groupingBy(a -> this.typeMapper.apply(a.getClass())));
        for (Map.Entry<Class, List<IAnnotation>> annotationsGroup : annotations.entrySet()) {
            Class type = annotationsGroup.getKey();
            String alias = this.aliases.getAlias(type);
            IJsonConverter converter = this.aliases.getConverter(type);
            Validate.isTrue((alias != null && converter != null ? 1 : 0) != 0, (String)"%s has no alias and/or converter.", (Object[])new Object[]{type});
            Validate.isTrue((annotationsNode.get(alias) == null ? 1 : 0) != 0, (String)"Multiple groups have the same alias %s", (Object[])new Object[]{alias});
            annotationsNode.set(alias, converter.toJson(annotationsGroup.getValue()));
        }
        JsonNode documentNode = mapper.createObjectNode().put(TEXT_FIELD, doc.getText()).set(ANNOTATIONS_FIELD, (JsonNode)annotationsNode);
        gen.writeTree((TreeNode)documentNode);
    }

    @Override
    public INLPDocument deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectNode documentNode = (ObjectNode)p.readValueAsTree();
        TextNode textNode = (TextNode)documentNode.get(TEXT_FIELD);
        ObjectNode annotationsNode = (ObjectNode)documentNode.get(ANNOTATIONS_FIELD);
        ImmutableList annotationsNodeFields = annotationsNode != null ? ImmutableList.copyOf((Iterator)annotationsNode.fields()) : ImmutableList.of();
        String text = textNode.asText();
        ArrayList annotations = new ArrayList();
        for (Map.Entry field : annotationsNodeFields) {
            String alias = (String)field.getKey();
            Class<? extends IAnnotation> type = this.aliases.getType(alias);
            IJsonConverter<? extends IAnnotation> converter = this.aliases.getConverter(type);
            Validate.isTrue((type != null && converter != null ? 1 : 0) != 0, (String)"Alias %s has no type and/or converter.", (Object[])new Object[]{alias});
            annotations.addAll((Collection)converter.fromJson(text, (JsonNode)field.getValue()));
        }
        INLPDocument doc = this.factory.create(text);
        doc = doc.withAnnotations(annotations);
        return doc;
    }

    public static final class AnnotationTypesAliases {
        private final Map<String, Class<? extends IAnnotation>> aliasToType = new HashMap<String, Class<? extends IAnnotation>>();
        private final Map<Class<? extends IAnnotation>, String> typeToAlias = new HashMap<Class<? extends IAnnotation>, String>();
        private final Map<Class<? extends IAnnotation>, IJsonConverter<? extends List<? extends IAnnotation>>> converters = new HashMap<Class<? extends IAnnotation>, IJsonConverter<? extends List<? extends IAnnotation>>>();

        public <A extends IAnnotation> void putCustomList(String alias, Class<A> type, IJsonConverter<List<A>> converter) {
            this.aliasToType.put(alias, type);
            this.typeToAlias.put(type, alias);
            this.converters.put(type, converter);
            Validate.isTrue((this.aliasToType.size() == this.typeToAlias.size() ? 1 : 0) != 0, (String)"%s has duplicate mapping", (Object[])new Object[]{alias});
        }

        public <A extends IAnnotation> void putCustom(String alias, Class<A> type, IJsonConverter<A> converter) {
            this.putCustomList(alias, type, new ListJsonConverter<A>(converter));
        }

        public <A extends IAnnotation> void putNonValued(String alias, Class<A> type) {
            this.putCustom(alias, type, new AnnotationJsonConverter<A>(type));
        }

        public <V, VA extends IValuedAnnotation<V>> void putValued(String alias, Class<VA> type, Class<V> valueType, IJsonConverter<V> valueConverter) {
            this.putCustom(alias, type, new ValuedAnnotationJsonConverter<VA, V>(type, valueType, valueConverter));
        }

        public <V, VA extends IValuedAnnotation<V>> void putValued(String alias, Class<VA> type, Class<V> valueType, ObjectMapper jackson) {
            this.putCustom(alias, type, new ValuedAnnotationJsonConverter<VA, V>(type, valueType, new JacksonJsonConverter<V>(jackson, valueType)));
        }

        public Class<? extends IAnnotation> getType(String alias) {
            return this.aliasToType.get(alias);
        }

        public String getAlias(Class<? extends IAnnotation> type) {
            return this.typeToAlias.get(type);
        }

        public <A extends IAnnotation> IJsonConverter<A> getConverter(Class<A> type) {
            return this.converters.get(type);
        }
    }
}

