/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.serializers.json.jackson.document;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ru.ispras.texterra.serializers.json.jackson.document.IJsonConverter;

public final class ListJsonConverter<T>
implements IJsonConverter<List<T>> {
    private final IJsonConverter<T> wrapped;

    public ListJsonConverter(IJsonConverter<T> wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public List<T> fromJson(String text, JsonNode node) {
        ArrayList<T> result = new ArrayList<T>();
        Iterator it = node.iterator();
        while (it.hasNext()) {
            result.add(this.wrapped.fromJson(text, (JsonNode)it.next()));
        }
        return result;
    }

    @Override
    public JsonNode toJson(List<T> objects) {
        ArrayNode result = JsonNodeFactory.instance.arrayNode();
        objects.forEach(object -> result.add(this.wrapped.toJson(object)));
        return result;
    }
}

