/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.serializers.json.jackson.document;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.Constructor;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.serializers.json.jackson.document.IJsonConverter;
import ru.ispras.texterra.serializers.json.jackson.document.SpanJsonConverterHelper;

public final class AnnotationJsonConverter<A extends IAnnotation>
implements IJsonConverter<A> {
    private final SpanJsonConverterHelper spanConverter = new SpanJsonConverterHelper();
    private final Constructor<A> constructor;

    public AnnotationJsonConverter(Class<A> type) {
        try {
            this.constructor = type.getConstructor(IAnnotation.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public A fromJson(String text, JsonNode node) {
        try {
            IAnnotation span = this.spanConverter.fromJson(text, (ObjectNode)node);
            return (A)((IAnnotation)this.constructor.newInstance(span));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public JsonNode toJson(A annotation) {
        return this.spanConverter.toJson((IAnnotation)annotation);
    }
}

