/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.serializers.json.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;

public final class TagSetsJacksonSerializerHelper<T> {
    private static final String TYPE = "type";
    private static final String TAG = "tag";
    private final TagSetsAliases<T> aliases;
    private final Map<Class<? extends T>, Method> valueOfMethods;

    public TagSetsJacksonSerializerHelper(TagSetsAliases<T> aliases) {
        this.aliases = aliases;
        this.valueOfMethods = this.getValueOfMethods(((TagSetsAliases)aliases).typeToAlias.keySet());
    }

    private Map<Class<? extends T>, Method> getValueOfMethods(Set<Class<? extends T>> types) {
        return types.stream().map(type -> this.getValueOfMethod((Class<? extends T>)type)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Optional<Map.Entry<Class<? extends T>, Method>> getValueOfMethod(Class<? extends T> type) {
        try {
            return Optional.of(type.getMethod("valueOf", String.class)).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> method.getReturnType() == type).map(method -> new AbstractMap.SimpleEntry<Class, Method>(type, (Method)method));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    public T fromJson(ObjectNode node) {
        String alias = node.get(TYPE).asText();
        Class type = ((TagSetsAliases)this.aliases).getType(alias);
        String tag = node.get(TAG).asText();
        return this.valueOf(type, tag);
    }

    private T valueOf(Class<? extends T> type, String tag) {
        try {
            return (T)Optional.ofNullable(this.valueOfMethods.get(type)).orElseThrow(() -> new RuntimeException(String.format("%s has no valueOf(String) method.", type))).invoke(null, tag);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public ObjectNode toJson(T tag, ObjectMapper mapper) {
        ObjectNode result = mapper.createObjectNode();
        result.put(TYPE, ((TagSetsAliases)this.aliases).getAlias(tag.getClass()));
        result.put(TAG, tag.toString());
        return result;
    }

    public static final class TagSetsAliases<T> {
        private final Map<String, Class<? extends T>> aliasToType = new HashMap<String, Class<? extends T>>();
        private final Map<Class<? extends T>, String> typeToAlias = new HashMap<Class<? extends T>, String>();

        public void put(String alias, Class<? extends T> type) {
            this.aliasToType.put(alias, type);
            this.typeToAlias.put(type, alias);
            Validate.isTrue((this.aliasToType.size() == this.typeToAlias.size() ? 1 : 0) != 0, (String)"Alias %s has duplicate mapping.", (Object[])new Object[]{alias});
        }

        private String getAlias(Class<? extends T> type) {
            return Optional.ofNullable(this.typeToAlias.get(type)).orElseThrow(() -> new IllegalArgumentException(String.format("%s has no alias.", type)));
        }

        private Class<? extends T> getType(String alias) {
            return Optional.ofNullable(this.aliasToType.get(alias)).orElseThrow(() -> new IllegalArgumentException(String.format("Alias %s has no type.", alias)));
        }
    }
}

