/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.serializers.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import ru.ispras.texterra.serializers.json.jackson.IJacksonSerializer;

public final class MapAsArrayJacksonSerializer<T, K, V>
implements IJacksonSerializer<T> {
    private final Class<K> keyType;
    private final String keyLabel;
    private final Class<V> valueType;
    private final String valueLabel;
    private final Function<T, Map<K, V>> toMap;
    private final Function<Map<K, V>, T> fromMap;

    public MapAsArrayJacksonSerializer(Class<K> keyType, String keyLabel, Class<V> valueType, String valueLabel, Function<T, Map<K, V>> toMap, Function<Map<K, V>, T> fromMap) {
        this.keyType = keyType;
        this.keyLabel = keyLabel;
        this.valueType = valueType;
        this.valueLabel = valueLabel;
        this.toMap = toMap;
        this.fromMap = fromMap;
    }

    @Override
    public void serialize(T value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        ObjectMapper mapper = (ObjectMapper)gen.getCodec();
        ArrayNode result = mapper.createArrayNode();
        this.toMap.apply(value).entrySet().stream().map(entry -> {
            ObjectNode node = mapper.createObjectNode();
            node.set(this.keyLabel, mapper.valueToTree(entry.getKey()));
            node.set(this.valueLabel, mapper.valueToTree(entry.getValue()));
            return node;
        }).forEach(node -> result.add((JsonNode)node));
        gen.writeTree((TreeNode)result);
    }

    @Override
    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)p.getCodec();
        ArrayNode node = (ArrayNode)p.readValueAsTree();
        Map<Object, Object> map = ImmutableList.copyOf((Iterator)node.elements()).stream().collect(Collectors.toMap(element -> this.treeToValue(mapper, element.get(this.keyLabel), this.keyType), element -> this.treeToValue(mapper, element.get(this.valueLabel), this.valueType)));
        return this.fromMap.apply(map);
    }

    private <S> S treeToValue(ObjectMapper mapper, JsonNode node, Class<S> type) {
        try {
            return (S)mapper.treeToValue((TreeNode)node, type);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

