/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.serializers.json.datamodel;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import ru.ispras.texterra.core.common.concept.AttributedConcept;
import ru.ispras.texterra.serializers.json.datamodel.VAttributedConceptSet;

public final class AttributedConceptSet
implements VAttributedConceptSet {
    private final ImmutableSet<AttributedConcept> concepts;

    private AttributedConceptSet(Iterable<? extends AttributedConcept> concepts) {
        this.concepts = ImmutableSet.copyOf(concepts);
    }

    private AttributedConceptSet(AttributedConceptSet original, ImmutableSet<AttributedConcept> concepts) {
        this.concepts = concepts;
    }

    public ImmutableSet<AttributedConcept> getConcepts() {
        return this.concepts;
    }

    public final AttributedConceptSet withConcepts(AttributedConcept ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new AttributedConceptSet(this, (ImmutableSet<AttributedConcept>)newValue);
    }

    public final AttributedConceptSet withConcepts(Iterable<? extends AttributedConcept> elements) {
        if (this.concepts == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new AttributedConceptSet(this, (ImmutableSet<AttributedConcept>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AttributedConceptSet && this.equalTo((AttributedConceptSet)another);
    }

    private boolean equalTo(AttributedConceptSet another) {
        return this.concepts.equals(another.concepts);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.concepts.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AttributedConceptSet").omitNullValues().add("concepts", this.concepts).toString();
    }

    public static AttributedConceptSet of(Set<AttributedConcept> concepts) {
        return AttributedConceptSet.of(concepts);
    }

    public static AttributedConceptSet of(Iterable<? extends AttributedConcept> concepts) {
        return new AttributedConceptSet(concepts);
    }

    static AttributedConceptSet copyOf(VAttributedConceptSet instance) {
        if (instance instanceof AttributedConceptSet) {
            return (AttributedConceptSet)instance;
        }
        return AttributedConceptSet.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ImmutableSet.Builder<AttributedConcept> concepts = ImmutableSet.builder();

        private Builder() {
        }

        public final Builder from(AttributedConceptSet instance) {
            return this.from((VAttributedConceptSet)instance);
        }

        final Builder from(VAttributedConceptSet instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.addAllConcepts(instance.getConcepts());
            return this;
        }

        public final Builder addConcepts(AttributedConcept element) {
            this.concepts.add((Object)element);
            return this;
        }

        public final Builder addConcepts(AttributedConcept ... elements) {
            this.concepts.add((Object[])elements);
            return this;
        }

        public final Builder setConcepts(Iterable<? extends AttributedConcept> elements) {
            this.concepts = ImmutableSet.builder();
            return this.addAllConcepts(elements);
        }

        public final Builder addAllConcepts(Iterable<? extends AttributedConcept> elements) {
            this.concepts.addAll(elements);
            return this;
        }

        public AttributedConceptSet build() {
            return new AttributedConceptSet(null, this.concepts.build());
        }
    }
}

