/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.serializers.json;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.Map;
import ru.ispras.texterra.core.common.concept.Concept;
import ru.ispras.texterra.core.common.concept.Domain;
import ru.ispras.texterra.core.ekb.representation.TermCandidate;
import ru.ispras.texterra.core.nlp.datamodel.ConceptOccurrences;
import ru.ispras.texterra.core.nlp.datamodel.DisambiguatedPhrase;
import ru.ispras.texterra.core.nlp.datamodel.DomainAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.Emoticon;
import ru.ispras.texterra.core.nlp.datamodel.Frame;
import ru.ispras.texterra.core.nlp.datamodel.Hashtag;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.IWeightedSemanticContextValue;
import ru.ispras.texterra.core.nlp.datamodel.IsTweet;
import ru.ispras.texterra.core.nlp.datamodel.KeyconceptsSemanticContext;
import ru.ispras.texterra.core.nlp.datamodel.Language;
import ru.ispras.texterra.core.nlp.datamodel.Lemma;
import ru.ispras.texterra.core.nlp.datamodel.MeaningPhrase;
import ru.ispras.texterra.core.nlp.datamodel.Paragraph;
import ru.ispras.texterra.core.nlp.datamodel.Sentence;
import ru.ispras.texterra.core.nlp.datamodel.SentimentPolarity;
import ru.ispras.texterra.core.nlp.datamodel.SentimentSubjectivity;
import ru.ispras.texterra.core.nlp.datamodel.Token;
import ru.ispras.texterra.core.nlp.datamodel.URL;
import ru.ispras.texterra.core.nlp.datamodel.UserMention;
import ru.ispras.texterra.core.nlp.datamodel.WeightedSemanticContextValue;
import ru.ispras.texterra.core.nlp.datamodel.anaphora.ICoreference;
import ru.ispras.texterra.core.nlp.datamodel.ne.BBNNamedEntity;
import ru.ispras.texterra.core.nlp.datamodel.ne.DateNamedEntity;
import ru.ispras.texterra.core.nlp.datamodel.ne.INamedEntity;
import ru.ispras.texterra.core.nlp.datamodel.ne.LocationNamedEntity;
import ru.ispras.texterra.core.nlp.datamodel.ne.MoneyNamedEntity;
import ru.ispras.texterra.core.nlp.datamodel.ne.NamedEntityToken;
import ru.ispras.texterra.core.nlp.datamodel.ne.OrganizationNamedEntity;
import ru.ispras.texterra.core.nlp.datamodel.ne.PercentNamedEntity;
import ru.ispras.texterra.core.nlp.datamodel.ne.PersonNamedEntity;
import ru.ispras.texterra.core.nlp.datamodel.ne.TimeNamedEntity;
import ru.ispras.texterra.core.nlp.datamodel.pos.GeneralPOSTag;
import ru.ispras.texterra.core.nlp.datamodel.pos.IPOSTag;
import ru.ispras.texterra.core.nlp.datamodel.pos.POSToken;
import ru.ispras.texterra.core.nlp.datamodel.pos.kaist.KAISTPOSTag;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.IMorphProperties;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.Animacy;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.Aspect;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.Case;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.ComparisonDegree;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.Gender;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.IMorphCharacter;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.MilderComparisonDegree;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.Mode;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.Number;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.Person;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.Pronoun;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.Representation;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.Shortness;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.Tense;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.Voice;
import ru.ispras.texterra.core.nlp.datamodel.pos.penn.PennPOSTag;
import ru.ispras.texterra.core.nlp.datamodel.pos.ruscorpora.RuscorporaPOSTag;
import ru.ispras.texterra.core.nlp.datamodel.pos.synTagRus.SynTagRusPOSTag;
import ru.ispras.texterra.core.nlp.datamodel.representation.Commonness;
import ru.ispras.texterra.core.nlp.datamodel.representation.InfoMeasure;
import ru.ispras.texterra.core.nlp.datamodel.representation.Term;
import ru.ispras.texterra.core.nlp.datamodel.spelling.Misspelling;
import ru.ispras.texterra.core.nlp.datamodel.spelling.SpellingCorrectionToken;
import ru.ispras.texterra.core.nlp.datamodel.spelling.SpellingSuggestion;
import ru.ispras.texterra.core.nlp.datamodel.syntax.ISyntaxRelationValue;
import ru.ispras.texterra.core.nlp.datamodel.syntax.SyntaxRelation;
import ru.ispras.texterra.core.nlp.serializers.ISerializer;
import ru.ispras.texterra.core.nlp.serializers.ISerializerFactory;
import ru.ispras.texterra.serializers.json.JsonSerializer;
import ru.ispras.texterra.serializers.json.datamodel.AttributedConceptSet;
import ru.ispras.texterra.serializers.json.jackson.AttributedConceptSetAsObjectSerializer;
import ru.ispras.texterra.serializers.json.jackson.IJacksonSerializer;
import ru.ispras.texterra.serializers.json.jackson.JacksonJsonMapper;
import ru.ispras.texterra.serializers.json.jackson.MapAsArrayJacksonSerializer;
import ru.ispras.texterra.serializers.json.jackson.TagSetsJacksonSerializer;
import ru.ispras.texterra.serializers.json.jackson.TagSetsJacksonSerializerHelper;
import ru.ispras.texterra.serializers.json.jackson.document.AnnotationJsonConverter;
import ru.ispras.texterra.serializers.json.jackson.document.JacksonJsonConverter;
import ru.ispras.texterra.serializers.json.jackson.document.MappingJsonConverter;
import ru.ispras.texterra.serializers.json.jackson.document.NLPDocumentJacksonSerializer;
import ru.ispras.texterra.serializers.json.jackson.document.ValuedAnnotationJsonConverter;
import ru.ispras.texterra.serializers.json.jackson.document.entities.ConceptOccurrencesValueJsonConverter;
import ru.ispras.texterra.serializers.json.jackson.document.entities.CoreferenceListJsonConverter;
import ru.ispras.texterra.serializers.json.jackson.document.entities.SyntaxRelationValueJsonConverter;
import ru.ispras.texterra.serializers.json.jackson.entities.ConceptJacksonSerializer;
import ru.ispras.texterra.serializers.json.jackson.entities.DomainJacksonSerializer;
import ru.ispras.texterra.serializers.json.jackson.entities.POSTagJacksonSerializer;
import ru.ispras.texterra.serializers.json.jackson.entities.TexterraLanguageJacksonSerializer;
import ru.ispras.texterra.utils.language.ITexterraLanguage;

public final class JsonSerializerFactory
implements ISerializerFactory {
    private final boolean prettyPrint;

    public JsonSerializerFactory() {
        this(false);
    }

    public JsonSerializerFactory(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public ISerializer create() {
        ObjectMapper jackson = new ObjectMapper();
        if (this.prettyPrint) {
            jackson.enable(SerializationFeature.INDENT_OUTPUT);
        }
        SimpleModule texterraModule = new SimpleModule();
        this.addSerializer(texterraModule, ITexterraLanguage.class, new TexterraLanguageJacksonSerializer());
        this.addSerializer(texterraModule, Domain.class, new DomainJacksonSerializer());
        this.addSerializer(texterraModule, Concept.class, new ConceptJacksonSerializer());
        this.addPOSTagSerializer(texterraModule);
        this.addNamedEntitySerializer(texterraModule);
        this.addMeaningsWithCommonnessSerializer(texterraModule);
        this.addSemanticContextValueSerializer(texterraModule);
        this.addNLPDocumentSerializer(texterraModule, jackson);
        this.addSerializer(texterraModule, AttributedConceptSet.class, new AttributedConceptSetAsObjectSerializer());
        jackson.registerModule((Module)texterraModule);
        return new JsonSerializer(jackson);
    }

    private void addPOSTagSerializer(SimpleModule module) {
        TagSetsJacksonSerializerHelper.TagSetsAliases<IPOSTag> posAliases = new TagSetsJacksonSerializerHelper.TagSetsAliases<IPOSTag>();
        posAliases.put("general", GeneralPOSTag.class);
        posAliases.put("penn", PennPOSTag.class);
        posAliases.put("ruscorpora", RuscorporaPOSTag.class);
        posAliases.put("syn-tag-rus", SynTagRusPOSTag.class);
        posAliases.put("kaist", KAISTPOSTag.class);
        TagSetsJacksonSerializerHelper.TagSetsAliases<IMorphCharacter> characterAliases = new TagSetsJacksonSerializerHelper.TagSetsAliases<IMorphCharacter>();
        characterAliases.put("animacy", Animacy.class);
        characterAliases.put("aspect", Aspect.class);
        characterAliases.put("case", Case.class);
        characterAliases.put("comparison-degree", ComparisonDegree.class);
        characterAliases.put("gender", Gender.class);
        characterAliases.put("milder-comparison-degree", MilderComparisonDegree.class);
        characterAliases.put("mode", Mode.class);
        characterAliases.put("number", Number.class);
        characterAliases.put("person", Person.class);
        characterAliases.put("pronoun", Pronoun.class);
        characterAliases.put("representation", Representation.class);
        characterAliases.put("shortness", Shortness.class);
        characterAliases.put("tense", Tense.class);
        characterAliases.put("voice", Voice.class);
        this.addSerializer(module, IMorphProperties.class, new POSTagJacksonSerializer(posAliases, characterAliases));
    }

    private void addNamedEntitySerializer(SimpleModule module) {
        TagSetsJacksonSerializerHelper.TagSetsAliases<Object> namedEntityAliases = new TagSetsJacksonSerializerHelper.TagSetsAliases<Object>();
        namedEntityAliases.put("bbn", BBNNamedEntity.class);
        namedEntityAliases.put("date", DateNamedEntity.class);
        namedEntityAliases.put("location", LocationNamedEntity.class);
        namedEntityAliases.put("money", MoneyNamedEntity.class);
        namedEntityAliases.put("organization", OrganizationNamedEntity.class);
        namedEntityAliases.put("percent", PercentNamedEntity.class);
        namedEntityAliases.put("person", PersonNamedEntity.class);
        namedEntityAliases.put("time", TimeNamedEntity.class);
        this.addSerializer(module, INamedEntity.class, new TagSetsJacksonSerializer(namedEntityAliases));
    }

    private void addMeaningsWithCommonnessSerializer(SimpleModule module) {
        this.addSerializer(module, MeaningPhrase.MeaningsWithCommonness.class, new MapAsArrayJacksonSerializer<MeaningPhrase.MeaningsWithCommonness, Concept, Double>(Concept.class, "meaning", Double.class, "commonness", mwc -> mwc.getMeaningsWithCommonness(), MeaningPhrase.MeaningsWithCommonness::new));
    }

    private void addSemanticContextValueSerializer(SimpleModule module) {
        this.addSerializer(module, IWeightedSemanticContextValue.class, new MapAsArrayJacksonSerializer<IWeightedSemanticContextValue, Concept, Double>(Concept.class, "concept", Double.class, "weight", ksc -> ksc.getWeights(), WeightedSemanticContextValue::new));
    }

    private void addNLPDocumentSerializer(SimpleModule module, ObjectMapper jackson) {
        NLPDocumentJacksonSerializer.AnnotationTypesAliases aliases = new NLPDocumentJacksonSerializer.AnnotationTypesAliases();
        aliases.putCustomList("coreference", ICoreference.class, new CoreferenceListJsonConverter());
        aliases.putValued("language", Language.class, ITexterraLanguage.class, jackson);
        aliases.putNonValued("paragraph", Paragraph.class);
        aliases.putNonValued("sentence", Sentence.class);
        aliases.putNonValued("token", Token.class);
        aliases.putValued("pos-token", POSToken.class, IMorphProperties.class, jackson);
        aliases.putValued("lemma", Lemma.class, String.class, jackson);
        aliases.putValued("tweet", IsTweet.class, Boolean.class, jackson);
        aliases.putNonValued("url", URL.class);
        aliases.putNonValued("emoticon", Emoticon.class);
        aliases.putNonValued("user-mention", UserMention.class);
        aliases.putNonValued("hashtag", Hashtag.class);
        aliases.putValued("meaning-phrase", MeaningPhrase.class, MeaningPhrase.MeaningsWithCommonness.class, jackson);
        aliases.putValued("frame", Frame.class, MeaningPhrase.MeaningsWithCommonness.class, jackson);
        aliases.putValued("disambiguated-phrase", DisambiguatedPhrase.class, Concept.class, jackson);
        aliases.putValued("domain", DomainAnnotation.class, Domain.class, jackson);
        aliases.putValued("concept-occurrences", ConceptOccurrences.class, ConceptOccurrences.ConceptOccurrencesValue.class, new ConceptOccurrencesValueJsonConverter(new JacksonJsonConverter<Concept>(jackson, Concept.class), new ValuedAnnotationJsonConverter<DisambiguatedPhrase, Concept>(DisambiguatedPhrase.class, Concept.class, new JacksonJsonConverter<Concept>(jackson, Concept.class))));
        aliases.putValued("keyconcepts", KeyconceptsSemanticContext.class, IWeightedSemanticContextValue.class, jackson);
        aliases.putValued("named-entity", NamedEntityToken.class, INamedEntity.class, jackson);
        aliases.putNonValued("subjectivity", SentimentSubjectivity.class);
        aliases.putValued("polarity", SentimentPolarity.class, SentimentPolarity.Direction.class, jackson);
        aliases.putNonValued("misspelling", Misspelling.class);
        aliases.putValued("spelling-suggestion", SpellingSuggestion.class, String.class, jackson);
        aliases.putValued("spelling-correction-token", SpellingCorrectionToken.class, String.class, jackson);
        aliases.putValued("syntax-relation", SyntaxRelation.class, ISyntaxRelationValue.class, new SyntaxRelationValueJsonConverter(new AnnotationJsonConverter<Token>(Token.class)));
        aliases.putNonValued("term-candidate", TermCandidate.class);
        aliases.putNonValued("term", Term.class);
        aliases.putCustom("commonness", Commonness.class, new ValuedAnnotationJsonConverter<Commonness, Map>(Commonness.class, Map.class, new MappingJsonConverter<Map, MeaningPhrase.MeaningsWithCommonness>(new JacksonJsonConverter<MeaningPhrase.MeaningsWithCommonness>(jackson, MeaningPhrase.MeaningsWithCommonness.class), mwc -> mwc.getMeaningsWithCommonness(), MeaningPhrase.MeaningsWithCommonness::new)));
        aliases.putValued("info-measure", InfoMeasure.class, Double.class, jackson);
        this.addSerializer(module, INLPDocument.class, new NLPDocumentJacksonSerializer(aliases, c -> {
            if (ICoreference.class.isAssignableFrom((Class<?>)c)) {
                return ICoreference.class;
            }
            return c;
        }));
    }

    private <T> void addSerializer(SimpleModule module, Class<T> type, IJacksonSerializer<T> serializer) {
        JacksonJsonMapper<T> mapper = new JacksonJsonMapper<T>(type, serializer);
        module.addDeserializer(type, mapper.getDeserializer());
        module.addSerializer(type, mapper.getSerializer());
    }
}

