/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.serializers.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import ru.ispras.texterra.core.nlp.serializers.ISerializer;

final class JsonSerializer
implements ISerializer {
    private final ObjectMapper jackson;

    public JsonSerializer(ObjectMapper jackson) {
        this.jackson = jackson;
    }

    public void write(Object obj, OutputStream out) {
        try {
            this.jackson.writeValue(out, obj);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <T> T read(Class<T> c, InputStream in) {
        try {
            return (T)this.jackson.readValue(in, c);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

