/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.trie;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.LemmaSuggestion;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.StemSuffix;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.trie.InflectionalModel;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.trie.Suffixes;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.trie.TriePath;

class TrieNode
implements Serializable {
    private static final long serialVersionUID = 6338853155005028084L;
    private InflectionalModel selfModel = null;
    private InflectionalModel descendantsAndSelfModel = new InflectionalModel();
    private TrieNode[] children = null;
    private char startChar;

    protected void addNodesAlongPath(char[] charsPath, Suffixes suffixes) {
        TrieNode current = this;
        for (char ch : charsPath) {
            current = current.getOrAddNode(ch);
        }
        current.addSelfInflectionalModel(suffixes);
    }

    private TrieNode getOrAddNode(char ch) {
        TrieNode node = this.getNode(ch);
        if (node == null) {
            node = this.addNode(ch);
        }
        return node;
    }

    private TrieNode getNode(char ch) {
        return this.hasChildren() ? this.get(ch) : null;
    }

    private TrieNode get(char ch) {
        int pos = ch - this.startChar;
        return pos < 0 || pos >= this.children.length ? null : this.children[pos];
    }

    private TrieNode addNode(char ch) {
        TrieNode node = new TrieNode();
        this.put(ch, node);
        return node;
    }

    private void put(char ch, TrieNode node) {
        if (this.children == null) {
            this.children = new TrieNode[]{node};
            this.startChar = ch;
        } else {
            this.expandChildrenIfRequired(ch);
            this.children[ch - this.startChar] = node;
        }
    }

    private void expandChildrenIfRequired(char ch) {
        if (ch >= this.startChar + this.children.length) {
            this.children = Arrays.copyOf(this.children, ch - this.startChar + 1);
        } else if (ch < this.startChar) {
            TrieNode[] tmp = new TrieNode[this.children.length + this.startChar - ch];
            System.arraycopy(this.children, 0, tmp, this.startChar - ch, this.children.length);
            this.startChar = ch;
            this.children = tmp;
        }
    }

    private void addSelfInflectionalModel(Suffixes suffixes) {
        this.initInflectionalModel();
        this.selfModel.add(suffixes);
    }

    private void initInflectionalModel() {
        if (!this.hasInflectionalModel()) {
            this.selfModel = new InflectionalModel();
        }
    }

    private boolean hasInflectionalModel() {
        return null != this.selfModel;
    }

    protected void optimizeInflectionalModels() {
        LinkedList<TrieNode> nodeQueue = new LinkedList<TrieNode>();
        HashMap<TrieNode, TrieNode> toParents = new HashMap<TrieNode, TrieNode>();
        nodeQueue.add(this);
        while (!nodeQueue.isEmpty()) {
            TrieNode currentElement = (TrieNode)nodeQueue.poll();
            currentElement.addInflectModelToSelfAndDescendants(toParents);
            currentElement.queueChildNodes(nodeQueue, toParents);
        }
    }

    private void addInflectModelToSelfAndDescendants(Map<TrieNode, TrieNode> toParents) {
        if (this.hasInflectionalModel()) {
            TrieNode current = this;
            while (current != null) {
                current.addDescendantsAndSelfInflectionalModel(this.selfModel);
                current = toParents.get(current);
            }
        }
    }

    private void queueChildNodes(Queue<TrieNode> nodeQueue, Map<TrieNode, TrieNode> toParents) {
        for (TrieNode child : this.getChildNodes()) {
            nodeQueue.add(child);
            toParents.put(child, this);
        }
    }

    private void addDescendantsAndSelfInflectionalModel(InflectionalModel model) {
        this.descendantsAndSelfModel.add(model);
    }

    private List<TrieNode> getChildNodes() {
        return this.hasChildren() ? this.collectChildren() : Collections.emptyList();
    }

    private List<TrieNode> collectChildren() {
        ArrayList<TrieNode> nodes = new ArrayList<TrieNode>(this.children.length);
        for (TrieNode n : this.children) {
            if (n == null) continue;
            nodes.add(n);
        }
        return nodes;
    }

    private boolean hasChildren() {
        return this.children != null;
    }

    public List<LemmaSuggestion> getSuggestionsForStemAndSuffix(StemSuffix stemSuffix) {
        return TrieNode.getSuggestionsForStemAndSuffix(stemSuffix, this.selfModel);
    }

    public List<LemmaSuggestion> getSuggestionsFromAllDescendantsWithInflectModel(StemSuffix stemSuffix) {
        return TrieNode.getSuggestionsForStemAndSuffix(stemSuffix, this.descendantsAndSelfModel);
    }

    private static List<LemmaSuggestion> getSuggestionsForStemAndSuffix(StemSuffix stemSuffix, InflectionalModel model) {
        String stem = stemSuffix.getStem();
        String suffix = stemSuffix.getSuffix();
        ArrayList<LemmaSuggestion> result = new ArrayList<LemmaSuggestion>();
        for (String normalSuffix : TrieNode.getRelevantNormalSuffixes(suffix, model)) {
            result.add(new LemmaSuggestion(stem, suffix, normalSuffix));
        }
        return result;
    }

    private static List<String> getRelevantNormalSuffixes(String suffix, InflectionalModel model) {
        return model != null ? model.getNormalSuffixes(suffix) : Collections.emptyList();
    }

    public TriePath getPath(char[] chars, StemSuffix stemSuffix) {
        char ch;
        ArrayList<TrieNode> path = new ArrayList<TrieNode>();
        path.add(this);
        TrieNode current = this;
        char[] cArray = chars;
        int n = cArray.length;
        for (int i = 0; i < n && (current = current.getNode(ch = cArray[i])) != null; ++i) {
            path.add(current);
        }
        return new TriePath(path, stemSuffix, chars.length + 1);
    }
}

