/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.trie;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class Suffixes {
    private String mainSuffix;
    private Set<String> suffixesSet;

    public Suffixes(String suffixesStr) {
        List<String> suffixes = Arrays.asList(suffixesStr.split(","));
        if (suffixes.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.mainSuffix = suffixes.get(0).intern();
        this.suffixesSet = this.makeSetWithInternStrings(suffixes);
    }

    private Set<String> makeSetWithInternStrings(List<String> items) {
        HashSet<String> result = new HashSet<String>();
        for (String item : items) {
            result.add(item.intern());
        }
        return result;
    }

    public String getMainSuffix() {
        return this.mainSuffix;
    }

    public boolean contains(String suffix) {
        return this.suffixesSet.contains(suffix);
    }

    public Set<String> getSuffixes() {
        return this.suffixesSet;
    }
}

