/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.trie;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.StemSuffix;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.trie.DictionaryEntity;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.trie.DictionaryEntityReader;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.trie.TrieNode;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.trie.TriePath;

public class StemTrie
implements Serializable {
    private static final long serialVersionUID = 2124485556437994079L;
    private Map<String, TrieNode> stemTrie;
    private int rootLength;

    public StemTrie(InputStream input, int rootLength) throws IOException {
        this.rootLength = rootLength;
        this.buildArray(input, rootLength);
    }

    private void buildArray(InputStream input, int rootLength) throws IOException {
        DictionaryEntity dictEntity;
        this.stemTrie = new HashMap<String, TrieNode>();
        DictionaryEntityReader reader = new DictionaryEntityReader(input, rootLength);
        while ((dictEntity = reader.readNextDictEntity()) != null) {
            String stem = dictEntity.getStem();
            TrieNode node = this.getStartNode(stem);
            this.tryAddToNode(node, dictEntity);
        }
        reader.close();
        this.optimizeTrieNodes();
    }

    private void optimizeTrieNodes() {
        for (TrieNode node : this.stemTrie.values()) {
            node.optimizeInflectionalModels();
        }
    }

    private void tryAddToNode(TrieNode node, DictionaryEntity dictEntity) {
        String stem = dictEntity.getStem();
        char[] charPath = this.getLettersAfterRootSuffixReverse(stem);
        if (this.isValidCharPath(charPath)) {
            node.addNodesAlongPath(charPath, dictEntity.getSuffixes());
        }
    }

    private boolean isValidCharPath(char[] chars) {
        for (char ch : chars) {
            if (ch >= '\u0430' && ch <= '\u044f') continue;
            return false;
        }
        return true;
    }

    private TrieNode getStartNode(String stem) {
        String suffix = this.getStemRootSuffix(stem);
        TrieNode node = this.stemTrie.get(suffix);
        if (node == null) {
            node = new TrieNode();
            this.stemTrie.put(suffix, node);
        }
        return node;
    }

    public TriePath getTriePathForStem(StemSuffix stemSuffix) {
        String stem = stemSuffix.getStem();
        String suffix = this.getStemRootSuffix(stem);
        TrieNode node = this.stemTrie.get(suffix);
        if (node != null) {
            char[] reversedPrefixChars = this.getLettersAfterRootSuffixReverse(stem);
            return node.getPath(reversedPrefixChars, stemSuffix);
        }
        return new TriePath(Collections.emptyList(), stemSuffix, this.computeSplitPosition(stem) + 1);
    }

    private String getStemRootSuffix(String stem) {
        int start = this.computeSplitPosition(stem);
        return stem.substring(start);
    }

    private char[] getLettersAfterRootSuffixReverse(String stem) {
        int charsToCopy = this.computeSplitPosition(stem);
        char[] result = new char[charsToCopy];
        int insPos = 0;
        for (int i = charsToCopy - 1; i >= 0; --i) {
            result[insPos] = stem.charAt(i);
            ++insPos;
        }
        return result;
    }

    private int computeSplitPosition(String stem) {
        return Math.max(0, stem.length() - this.rootLength);
    }
}

