/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.trie;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.trie.Suffixes;

class InflectionalModel
implements Serializable {
    private static final long serialVersionUID = -3650876204590262856L;
    private String[] suffixes = new String[0];
    private String[] normalSuffixes = new String[0];

    public List<String> getNormalSuffixes(String suffix) {
        int pos = this.computeStartPosition(suffix);
        if (pos < 0) {
            return Collections.emptyList();
        }
        return this.collectFromPosition(suffix, pos);
    }

    private List<String> collectFromPosition(String suffix, int pos) {
        ArrayList<String> result = new ArrayList<String>(5);
        do {
            result.add(this.normalSuffixes[pos]);
        } while (++pos < this.suffixes.length && suffix.equals(this.suffixes[pos]));
        return result;
    }

    private int computeStartPosition(String suffix) {
        int pos = Arrays.binarySearch(this.suffixes, suffix);
        if (pos < 0) {
            return pos;
        }
        while (pos > 0 && suffix.equals(this.suffixes[pos - 1])) {
            --pos;
        }
        return pos;
    }

    public void add(Suffixes suffixes) {
        String mainSuffix = suffixes.getMainSuffix();
        for (String suff : suffixes.getSuffixes()) {
            this.add(suff, mainSuffix);
        }
    }

    public void add(InflectionalModel modelToAdd) {
        for (int i = 0; i < modelToAdd.size(); ++i) {
            this.add(modelToAdd.suffixes[i], modelToAdd.normalSuffixes[i]);
        }
    }

    private int size() {
        return this.suffixes.length;
    }

    private void add(String suffix, String mainSuffix) {
        if (this.pairAlreadyExists(suffix, mainSuffix)) {
            return;
        }
        int pos = this.computeInsertionPosition(suffix);
        this.suffixes = this.insert(this.suffixes, suffix, pos);
        this.normalSuffixes = this.insert(this.normalSuffixes, mainSuffix, pos);
    }

    private int computeInsertionPosition(String suffix) {
        int pos = Arrays.binarySearch(this.suffixes, suffix);
        if (pos < 0) {
            pos = -pos - 1;
        } else {
            while (++pos < this.suffixes.length && suffix.equals(this.suffixes[pos])) {
            }
        }
        return pos;
    }

    private boolean pairAlreadyExists(String suffix, String normalSuffix) {
        List<String> normalSuffixes = this.getNormalSuffixes(suffix);
        return normalSuffixes.contains(normalSuffix);
    }

    private String[] insert(String[] items, String item, int pos) {
        String[] result = new String[items.length + 1];
        System.arraycopy(items, 0, result, 0, pos);
        result[pos] = item;
        System.arraycopy(items, pos, result, pos + 1, items.length - pos);
        return result;
    }
}

