/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.trie;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.trie.DictionaryEntity;

class DictionaryEntityReader {
    private BufferedReader reader;

    public DictionaryEntityReader(InputStream input, int suffixLen) throws IOException {
        this.reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
    }

    public DictionaryEntity readNextDictEntity() throws IOException {
        String line;
        while ((line = this.reader.readLine()) != null) {
            DictionaryEntity dictEnt = this.tryCreateDictionaryEntity(line);
            if (dictEnt == null) continue;
            return dictEnt;
        }
        return null;
    }

    private DictionaryEntity tryCreateDictionaryEntity(String line) {
        try {
            return new DictionaryEntity(line);
        }
        catch (IllegalArgumentException ignore) {
            return null;
        }
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

