/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.utils.lemmatizer.word.multilang.ru;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.StemSuffix;

public class StemSuffixPairsForWordComputer
implements Serializable {
    private static final long serialVersionUID = 427446213927975851L;
    private Set<String> validSuffixes;
    private int minStemLength;

    public StemSuffixPairsForWordComputer(InputStream inputStream, int minimumStemLength) throws IOException {
        this(StemSuffixPairsForWordComputer.readModel(inputStream), minimumStemLength);
    }

    protected StemSuffixPairsForWordComputer(Set<String> validSuffixSet, int minimumStemLength) {
        this.minStemLength = minimumStemLength;
        this.validSuffixes = validSuffixSet;
    }

    private static Set<String> readModel(InputStream inputStream) throws IOException {
        String strLine;
        HashSet<String> result = new HashSet<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
        while ((strLine = reader.readLine()) != null) {
            for (String suffix : strLine.split(",")) {
                result.add(suffix.intern());
            }
        }
        reader.close();
        return result;
    }

    public List<StemSuffix> getPossibleStemSuffixPairs(String word) {
        ArrayList<StemSuffix> result = new ArrayList<StemSuffix>();
        for (int i = this.minStemLength; i < word.length(); ++i) {
            String suffix = word.substring(i);
            if (!this.contains(suffix)) continue;
            String stem = word.substring(0, i);
            result.add(new StemSuffix(stem, suffix));
        }
        return result;
    }

    private boolean contains(String suffix) {
        return this.validSuffixes.contains(suffix);
    }
}

