/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.utils.lemmatizer.word.multilang.ru;

import java.util.Iterator;
import java.util.Set;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.ILemmaSuggestionChooser;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.ru.LemmaSuggestion;

public class LengthBasedChooser
implements ILemmaSuggestionChooser {
    private static final long serialVersionUID = 6336022703040284429L;

    @Override
    public String chooseSuggestion(Set<LemmaSuggestion> suggestions) {
        if (suggestions.isEmpty()) {
            return "";
        }
        Iterator<LemmaSuggestion> iterSuggestions = suggestions.iterator();
        LemmaSuggestion suggestion = iterSuggestions.next();
        String resultLemma = this.constructLemma(suggestion);
        double max = this.computeLemmaSuggestionScore(suggestion);
        while (iterSuggestions.hasNext()) {
            suggestion = iterSuggestions.next();
            double currentScore = this.computeLemmaSuggestionScore(suggestion);
            if (!(currentScore > max)) continue;
            max = currentScore;
            resultLemma = this.constructLemma(suggestion);
        }
        return resultLemma;
    }

    private String constructLemma(LemmaSuggestion suggestion) {
        return suggestion.getStem() + suggestion.getNormalSuffix();
    }

    private double computeLemmaSuggestionScore(LemmaSuggestion suggestion) {
        return suggestion.getSuffix().length() + suggestion.getNormalSuffix().length();
    }
}

