/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.utils.lemmatizer.word.multilang.en;

import ru.ispras.texterra.utils.language.EnglishLanguage;
import ru.ispras.texterra.utils.language.ITexterraLanguage;
import ru.ispras.texterra.utils.lemmatizer.word.multilang.LanguageDependentWordLemmatizer;

public class EnglishWordLemmatizer
extends LanguageDependentWordLemmatizer {
    private static final long serialVersionUID = -5817687112610413370L;

    public EnglishWordLemmatizer() {
        super((ITexterraLanguage)new EnglishLanguage());
    }

    public String getLemma(String word) {
        String uppercaseWord = word.toUpperCase();
        int len = word.length();
        if (len < 3) {
            return uppercaseWord;
        }
        if (uppercaseWord.endsWith("SES") || uppercaseWord.endsWith("ZES") || uppercaseWord.endsWith("SHES") || uppercaseWord.endsWith("CHES") || uppercaseWord.endsWith("XES")) {
            return new String(uppercaseWord.substring(0, len - 2));
        }
        if (uppercaseWord.endsWith("IES")) {
            return new String(uppercaseWord.substring(0, len - 3) + "Y");
        }
        if (uppercaseWord.endsWith("VES")) {
            return new String(uppercaseWord.substring(0, len - 3) + "F");
        }
        if (uppercaseWord.endsWith("S") && !uppercaseWord.endsWith("SS")) {
            return new String(uppercaseWord.substring(0, len - 1));
        }
        return uppercaseWord;
    }
}

