/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.tools.nlp.base.pipelines.graph.sentence.opennlp;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import opennlp.tools.sentdetect.SentenceModel;
import ru.ispras.modis.utils.ClasspathUtils;
import ru.ispras.modis.utils.config.validation.ConfigurationProperty;
import ru.ispras.texterra.core.configuration.TexterraConfigurationFactory;
import ru.ispras.texterra.core.exceptions.TexterraConfigException;
import ru.ispras.texterra.core.nlp.annotators.IAnnotator;
import ru.ispras.texterra.core.nlp.annotators.OpenNLPSentenceDetector;
import ru.ispras.texterra.core.nlp.datamodel.IValuedAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.Language;
import ru.ispras.texterra.core.nlp.datamodel.Sentence;
import ru.ispras.texterra.tools.nlp.datamodel.NLPDocumentOptions;
import ru.ispras.texterra.tools.nlp.modelsio.AbstractOptionsBasedModelsIO;
import ru.ispras.texterra.tools.nlp.pipelines.graph.IPipelineNodeProvider;
import ru.ispras.texterra.tools.nlp.pipelines.graph.PipelineNode;

public final class PersistentOpenNLPSentenceDetectorProvider
implements IPipelineNodeProvider<Sentence, OpenNLPSentenceDetector>,
Serializable {
    private static final long serialVersionUID = -7271560054795744425L;
    @ConfigurationProperty
    private static final String modelNameProperty = "modelName";
    private static final String modelName = TexterraConfigurationFactory.getConfiguration().getStringProperty(PersistentOpenNLPSentenceDetectorProvider.class, "modelName");
    private final ModelsIO modelsIO = new ModelsIO();

    public PipelineNode<Sentence, OpenNLPSentenceDetector> get(NLPDocumentOptions options) {
        return new PipelineNode((IAnnotator)new OpenNLPSentenceDetector(this.modelsIO.load(options)));
    }

    public Set<Class<? extends IValuedAnnotation<?>>> getRequiredOptions() {
        return Collections.singleton(Language.class);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getClass().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj.getClass() == this.getClass();
    }

    private static final class ModelsIO
    extends AbstractOptionsBasedModelsIO<SentenceModel>
    implements Serializable {
        private static final long serialVersionUID = -6097322158067022909L;

        private ModelsIO() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public SentenceModel load(NLPDocumentOptions options) {
            String modelsPath = this.getModelsPath(options);
            try (InputStream in = ClasspathUtils.getResourceAsStream((String)modelsPath, (String)modelName);){
                SentenceModel sentenceModel = new SentenceModel(in);
                return sentenceModel;
            }
            catch (IOException e) {
                throw new TexterraConfigException("Can't load model for " + OpenNLPSentenceDetector.class.getName(), (Throwable)e);
            }
        }

        public void save(NLPDocumentOptions options, SentenceModel model) {
            throw new UnsupportedOperationException("Saving of OpenNLP sentence detector model is not implemented.");
        }
    }
}

