/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.tools.nlp.base.pipelines.graph.pos;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import ru.ispras.texterra.core.nlp.annotators.IAnnotator;
import ru.ispras.texterra.core.nlp.annotators.pos.PronounPOSTagger;
import ru.ispras.texterra.core.nlp.datamodel.IToken;
import ru.ispras.texterra.core.nlp.datamodel.IValuedAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.Language;
import ru.ispras.texterra.core.nlp.datamodel.pos.POSToken;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.Pronoun;
import ru.ispras.texterra.core.nlp.factories.IDocumentFactory;
import ru.ispras.texterra.tools.nlp.base.factories.WrapperPronounDocFactory;
import ru.ispras.texterra.tools.nlp.datamodel.NLPDocumentOptions;
import ru.ispras.texterra.tools.nlp.modelsio.AbstractOptionsBasedModelsIO;
import ru.ispras.texterra.tools.nlp.modelsio.PropertiesOptionsBasedModelsIO;
import ru.ispras.texterra.tools.nlp.pipelines.graph.IPipelineNodeProvider;
import ru.ispras.texterra.tools.nlp.pipelines.graph.PipelineNode;
import ru.ispras.texterra.tools.nlp.pipelines.graph.PipelineNodeDependencies;

public class WrapperPronounPOSTaggerProvider
implements IPipelineNodeProvider<POSToken, PronounPOSTagger>,
Serializable {
    private static final long serialVersionUID = 1407490545327159511L;
    private final IPipelineNodeProvider<POSToken, ? extends IAnnotator<POSToken>> wrappedPOSProvider;
    private final AbstractOptionsBasedModelsIO<Map<String, Pronoun>> pronounMapIO = new PronounMapIO();

    public WrapperPronounPOSTaggerProvider(IPipelineNodeProvider<POSToken, ? extends IAnnotator<POSToken>> persistentPOSTaggerProvider) {
        this.wrappedPOSProvider = persistentPOSTaggerProvider;
    }

    public PipelineNode<POSToken, PronounPOSTagger> get(NLPDocumentOptions options) {
        return new PipelineNode((IDocumentFactory)new WrapperPronounDocFactory(), new PipelineNodeDependencies().withSoftExplicitDependencies(new IPipelineNodeProvider[]{this.wrappedPOSProvider}).withSoftImplicitDependencies(new Class[]{IToken.class}), (IAnnotator)new PronounPOSTagger((Map)this.pronounMapIO.load(options)));
    }

    public Set<Class<? extends IValuedAnnotation<?>>> getRequiredOptions() {
        return Collections.singleton(Language.class);
    }

    private static class PronounMapIO
    extends AbstractOptionsBasedModelsIO<Map<String, Pronoun>> {
        private final AbstractOptionsBasedModelsIO<Properties> modelsIO = new PropertiesOptionsBasedModelsIO("pronoun-wordforms");

        private PronounMapIO() {
        }

        public Map<String, Pronoun> load(NLPDocumentOptions options) {
            Properties properties = (Properties)this.modelsIO.load(options);
            ArrayList<String> personalPronouns = new ArrayList<String>(Arrays.asList(properties.getProperty("personalPronounWordforms").split(",")));
            ArrayList<String> reflexivePronouns = new ArrayList<String>(Arrays.asList(properties.getProperty("reflexivePronounWordforms").split(",")));
            ArrayList<String> deicticPronouns = new ArrayList<String>(Arrays.asList(properties.getProperty("deicticPronounWordforms").split(",")));
            ArrayList<String> possessivePronouns = new ArrayList<String>(Arrays.asList(properties.getProperty("possessivePronounWordforms").split(",")));
            HashMap<String, Pronoun> pronounMap = new HashMap<String, Pronoun>();
            pronounMap.putAll(this.makeMapFromPronList(personalPronouns, Pronoun.PERSONAL));
            pronounMap.putAll(this.makeMapFromPronList(reflexivePronouns, Pronoun.REFLEXIVE));
            pronounMap.putAll(this.makeMapFromPronList(deicticPronouns, Pronoun.DEICTIC));
            pronounMap.putAll(this.makeMapFromPronList(possessivePronouns, Pronoun.POSSESSIVE));
            return pronounMap;
        }

        private Map<String, Pronoun> makeMapFromPronList(List<String> pronouns, Pronoun pronType) {
            HashMap<String, Pronoun> pronounMap = new HashMap<String, Pronoun>();
            for (String pron : pronouns) {
                pronounMap.put(pron, pronType);
            }
            return pronounMap;
        }

        public void save(NLPDocumentOptions options, Map<String, Pronoun> model) {
            throw new UnsupportedOperationException("Saving of pronoun types map is not supported.");
        }
    }
}

