/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.tools.nlp.base.pipelines.graph;

import ru.ispras.texterra.core.nlp.annotators.pos.hierarchical.pipelines.PersistentPOSTaggerProvider;
import ru.ispras.texterra.core.nlp.datamodel.Emoticon;
import ru.ispras.texterra.core.nlp.datamodel.Hashtag;
import ru.ispras.texterra.core.nlp.datamodel.IToken;
import ru.ispras.texterra.core.nlp.datamodel.IsTweet;
import ru.ispras.texterra.core.nlp.datamodel.Language;
import ru.ispras.texterra.core.nlp.datamodel.Lemma;
import ru.ispras.texterra.core.nlp.datamodel.Paragraph;
import ru.ispras.texterra.core.nlp.datamodel.Sentence;
import ru.ispras.texterra.core.nlp.datamodel.URL;
import ru.ispras.texterra.core.nlp.datamodel.UserMention;
import ru.ispras.texterra.core.nlp.datamodel.pos.POSToken;
import ru.ispras.texterra.tools.nlp.base.pipelines.graph.emoticon.EmoticonDetectorProvider;
import ru.ispras.texterra.tools.nlp.base.pipelines.graph.hashtag.HashtagDetectorProvider;
import ru.ispras.texterra.tools.nlp.base.pipelines.graph.language.PersistentCybozuLanguageDetectorProvider;
import ru.ispras.texterra.tools.nlp.base.pipelines.graph.lemma.lemmagen.PersistentLemmaGenLemmatizerProvider;
import ru.ispras.texterra.tools.nlp.base.pipelines.graph.paragraph.NaiveParagraphDetectorProvider;
import ru.ispras.texterra.tools.nlp.base.pipelines.graph.pos.WrapperPronounPOSTaggerProvider;
import ru.ispras.texterra.tools.nlp.base.pipelines.graph.pos.opennlp.PersistentOpenNLPPOSTaggerProvider;
import ru.ispras.texterra.tools.nlp.base.pipelines.graph.sentence.WholeTextSentenceDetectorProvider;
import ru.ispras.texterra.tools.nlp.base.pipelines.graph.sentence.opennlp.PersistentOpenNLPSentenceDetectorProvider;
import ru.ispras.texterra.tools.nlp.base.pipelines.graph.token.SpecialSymbolDetacherProvider;
import ru.ispras.texterra.tools.nlp.base.pipelines.graph.token.URLAwareTokenizerProvider;
import ru.ispras.texterra.tools.nlp.base.pipelines.graph.token.opennlp.PersistentOpenNLPTokenizerProvider;
import ru.ispras.texterra.tools.nlp.base.pipelines.graph.tweet.NonTweetDetectorProvider;
import ru.ispras.texterra.tools.nlp.base.pipelines.graph.url.URLDetectorProvider;
import ru.ispras.texterra.tools.nlp.base.pipelines.graph.usermention.UserMentionDetectorProvider;
import ru.ispras.texterra.tools.nlp.datamodel.NLPDocumentOptions;
import ru.ispras.texterra.tools.nlp.pipelines.graph.GraphPipelineRegistry;
import ru.ispras.texterra.tools.nlp.pipelines.graph.IPipelineNodeProvider;
import ru.ispras.texterra.utils.language.RussianLanguage;

public final class TexterraToolsBaseModule
implements GraphPipelineRegistry.IConfigurationModule {
    public void configure(GraphPipelineRegistry.Configuration configuration) {
        configuration.register(Language.class, new NLPDocumentOptions(), (IPipelineNodeProvider)new PersistentCybozuLanguageDetectorProvider());
        configuration.register(IsTweet.class, new NLPDocumentOptions(), (IPipelineNodeProvider)new NonTweetDetectorProvider());
        configuration.register(URL.class, new NLPDocumentOptions(), (IPipelineNodeProvider)new URLDetectorProvider());
        configuration.register(Emoticon.class, new NLPDocumentOptions(), (IPipelineNodeProvider)new EmoticonDetectorProvider());
        configuration.register(UserMention.class, new NLPDocumentOptions(), (IPipelineNodeProvider)new UserMentionDetectorProvider());
        configuration.register(Hashtag.class, new NLPDocumentOptions(), (IPipelineNodeProvider)new HashtagDetectorProvider());
        configuration.register(Paragraph.class, new NLPDocumentOptions(), (IPipelineNodeProvider)new NaiveParagraphDetectorProvider());
        configuration.register(Sentence.class, new NLPDocumentOptions(), (IPipelineNodeProvider)new PersistentOpenNLPSentenceDetectorProvider());
        configuration.register(Sentence.class, new NLPDocumentOptions().withOption(IsTweet.class, (Object)true), (IPipelineNodeProvider)new WholeTextSentenceDetectorProvider());
        configuration.register(IToken.class, new NLPDocumentOptions(), (IPipelineNodeProvider)new SpecialSymbolDetacherProvider(new PersistentOpenNLPTokenizerProvider()));
        configuration.register(IToken.class, new NLPDocumentOptions().withOption(IsTweet.class, (Object)true), (IPipelineNodeProvider)new URLAwareTokenizerProvider(new SpecialSymbolDetacherProvider(new PersistentOpenNLPTokenizerProvider())));
        configuration.register(POSToken.class, new NLPDocumentOptions(), (IPipelineNodeProvider)new PersistentOpenNLPPOSTaggerProvider());
        configuration.register(POSToken.class, new NLPDocumentOptions().withOption(Language.class, (Object)new RussianLanguage()), (IPipelineNodeProvider)new WrapperPronounPOSTaggerProvider(new PersistentPOSTaggerProvider()));
        configuration.register(Lemma.class, new NLPDocumentOptions(), (IPipelineNodeProvider)new PersistentLemmaGenLemmatizerProvider());
    }
}

