/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.tools.nlp.base.datamodel.pos;

import ru.ispras.texterra.core.nlp.datamodel.pos.IPOSTagFactory;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.MorphPropertiesTagFactory;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.Animacy;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.Case;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.ComparisonDegree;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.Gender;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.Mode;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.Number;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.Person;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.Representation;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.Shortness;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.Tense;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.Voice;
import ru.ispras.texterra.core.nlp.datamodel.pos.penn.PennPOSTagFactory;
import ru.ispras.texterra.core.nlp.datamodel.pos.synTagRus.SynTagRusPOSTagFactory;
import ru.ispras.texterra.utils.language.ITexterraLanguage;

public class DefaultMorphPropertiesTagFactories {
    public static MorphPropertiesTagFactory getDefaultMorphPropertiesTagFactory(ITexterraLanguage language) {
        switch (language.getLanguageTag()) {
            case "ru": {
                return new MorphPropertiesTagFactory((IPOSTagFactory)new SynTagRusPOSTagFactory(), new Class[]{Case.class, ComparisonDegree.class, Gender.class, Mode.class, Number.class, Person.class, Representation.class, Shortness.class, Tense.class, Voice.class, Animacy.class});
            }
            case "en": {
                return new MorphPropertiesTagFactory((IPOSTagFactory)new PennPOSTagFactory(), new Class[0]);
            }
        }
        throw new IllegalArgumentException("Unsupported language " + language);
    }
}

