/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.pos.hierarchical.featureextractors;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.value.BooleanValue;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.datamodel.value.Type;
import ru.ispras.ml.featureextractors.IFeatureExtractor;
import ru.ispras.texterra.core.nlp.datamodel.IToken;

public class NumberFeatureExtractor
implements IFeatureExtractor<IToken> {
    private static final long serialVersionUID = 2111187411023123873L;
    private static Pattern numberRegex = Pattern.compile("\\d+");

    public Map<Feature, IValue> extract(IToken token) {
        String word = (String)token.getValue();
        HashMap<Feature, IValue> featuresValues = new HashMap<Feature, IValue>();
        featuresValues.put(new Feature("isNumber", Type.BOOLEAN), (IValue)BooleanValue.of((boolean)numberRegex.matcher(word).matches()));
        return featuresValues;
    }
}

