/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.pos.hierarchical.docextractors;

import java.util.List;
import java.util.stream.Collectors;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.contextextractors.IContextExtractor;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocumentHelper;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocumentWithAnnotation;

public class FilteringByContainerContextExtractor<A extends IAnnotation, CA extends IAnnotation>
implements IContextExtractor<NLPDocumentWithAnnotation<A>, A> {
    private static final long serialVersionUID = -7307779851477436673L;
    private final IContextExtractor<NLPDocumentWithAnnotation<A>, A> wrapped;
    private final Class<CA> containerType;

    public FilteringByContainerContextExtractor(IContextExtractor<NLPDocumentWithAnnotation<A>, A> wrapped, Class<CA> containerType) {
        this.wrapped = wrapped;
        this.containerType = containerType;
    }

    public List<A> extract(NLPDocumentWithAnnotation<A> source) {
        IAnnotation container = NLPDocumentHelper.getContainerAnnotation((INLPDocument)source.getDocument(), (IAnnotation)source.getAnnotation(), this.containerType);
        return this.wrapped.extract(source).stream().filter(ann -> NLPDocumentHelper.CONTAINS_RELATION.areInRelation(container, ann)).collect(Collectors.toList());
    }
}

