/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.pos.hierarchical.dictionary;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multiset;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import ru.ispras.texterra.core.nlp.annotators.pos.hierarchical.dictionary.IPOSDictionary;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.IMorphProperties;

public class POSDictionary
implements IPOSDictionary,
Serializable {
    private static final long serialVersionUID = -5552866111607009740L;
    private final Map<String, IMorphProperties> wordsWithTags;

    public POSDictionary(Map<String, IMorphProperties> wordsWithTags) {
        this.wordsWithTags = ImmutableMap.copyOf(wordsWithTags);
    }

    @Override
    public IMorphProperties getPOSTag(String word) {
        return this.wordsWithTags.get(word.toLowerCase());
    }

    public String toString() {
        return this.wordsWithTags.entrySet().stream().map(e -> "<" + (String)e.getKey() + " : " + e.getValue() + ">").collect(Collectors.joining("\n"));
    }

    public static class Builder {
        private final Map<String, Multiset<IMorphProperties>> dictionary = new HashMap<String, Multiset<IMorphProperties>>();
        private final int threshold;

        public Builder() {
            this.threshold = 1;
        }

        public Builder(int threshold) {
            this.threshold = threshold;
        }

        public void add(String word, IMorphProperties posMorphTag) {
            Multiset<IMorphProperties> tags = this.dictionary.getOrDefault(word, (Multiset<IMorphProperties>)HashMultiset.create());
            tags.add((Object)posMorphTag);
            this.dictionary.put(word, tags);
        }

        public IPOSDictionary build() {
            ImmutableMap.Builder wordsWithTagsBuilder = ImmutableMap.builder();
            for (Map.Entry<String, Multiset<IMorphProperties>> dictionaryEntry : this.dictionary.entrySet()) {
                Multiset.Entry tagEntry;
                Multiset<IMorphProperties> tags = dictionaryEntry.getValue();
                if (tags.elementSet().size() != 1 || (tagEntry = (Multiset.Entry)tags.entrySet().iterator().next()).getCount() < this.threshold) continue;
                wordsWithTagsBuilder.put((Object)dictionaryEntry.getKey(), tagEntry.getElement());
            }
            return new POSDictionary((Map<String, IMorphProperties>)wordsWithTagsBuilder.build());
        }
    }
}

