/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.pos.hierarchical.classifiers;

import java.io.Serializable;
import ru.ispras.texterra.core.nlp.datamodel.FastInRelationNLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.IToken;
import ru.ispras.texterra.core.nlp.datamodel.Sentence;
import ru.ispras.texterra.core.nlp.datamodel.relations.ContainedAnnotationRelationCacheBuilder;
import ru.ispras.texterra.core.nlp.datamodel.relations.ContainsAnnotationRelationCacheBuilder;
import ru.ispras.texterra.core.nlp.datamodel.relations.IAnnotationRelationCacheBuilder;
import ru.ispras.texterra.core.nlp.factories.DefaultDocumentFactory;
import ru.ispras.texterra.core.nlp.factories.IDocumentFactory;

public final class POSDocumentFactory
implements IDocumentFactory,
Serializable {
    private static final long serialVersionUID = -9163741172096099750L;
    private static final ContainedAnnotationRelationCacheBuilder CONTAINED_CACHE_BUILDER = new ContainedAnnotationRelationCacheBuilder();
    private static final ContainsAnnotationRelationCacheBuilder CONTAINS_CACHE_BUILDER = new ContainsAnnotationRelationCacheBuilder();
    private final IDocumentFactory wrapped = new DefaultDocumentFactory();

    public INLPDocument create(String text) {
        INLPDocument doc = this.wrapped.create(text);
        doc = this.wrapFastSentenceTokens(doc);
        doc = this.wrapFastTokenSentence(doc);
        return doc;
    }

    private INLPDocument wrapFastSentenceTokens(INLPDocument doc) {
        return new FastInRelationNLPDocument(doc, Sentence.class, IToken.class, (IAnnotationRelationCacheBuilder)CONTAINS_CACHE_BUILDER);
    }

    private INLPDocument wrapFastTokenSentence(INLPDocument doc) {
        return new FastInRelationNLPDocument(doc, IToken.class, Sentence.class, (IAnnotationRelationCacheBuilder)CONTAINED_CACHE_BUILDER);
    }
}

