/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.pos;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import ru.ispras.texterra.core.nlp.annotators.IAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.IToken;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocumentHelper;
import ru.ispras.texterra.core.nlp.datamodel.pos.POSToken;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.IMorphProperties;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.MorphProperties;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.Pronoun;

public final class PronounPOSTagger
implements IAnnotator<POSToken>,
Serializable {
    private static final long serialVersionUID = -1157745126450439750L;
    private final Map<String, Pronoun> pronounTypes;

    public PronounPOSTagger(Map<String, Pronoun> pronounTypes) {
        this.pronounTypes = pronounTypes;
    }

    public Collection<POSToken> annotate(INLPDocument doc) {
        List allPOS = doc.getAnnotations(POSToken.class);
        ArrayList<POSToken> result = new ArrayList<POSToken>(allPOS.size());
        for (POSToken posToken : allPOS) {
            String wordform = ((String)((IToken)NLPDocumentHelper.getCoincidingAnnotation((INLPDocument)doc, (IAnnotation)posToken, IToken.class)).getValue()).toLowerCase();
            if (this.pronounTypes.containsKey(wordform)) {
                ArrayList<Pronoun> morphCharacters = new ArrayList<Pronoun>(((IMorphProperties)posToken.getValue()).getMorphCharacters());
                morphCharacters.add(this.pronounTypes.get(wordform));
                result.add(new POSToken((IAnnotation)posToken, (IMorphProperties)new MorphProperties(((IMorphProperties)posToken.getValue()).getPOSTag(), morphCharacters)));
                continue;
            }
            result.add(posToken);
        }
        return result;
    }
}

