/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.geo.lucene.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermsFilter;
import ru.ispras.modis.geo.Coordinate;
import ru.ispras.modis.geo.lucene.PreciseDistanceFilter;
import ru.ispras.modis.geo.lucene.bounding.ApproximatingRectanglesComputer;
import ru.ispras.modis.geo.lucene.bounding.Rectangle;
import ru.ispras.modis.geo.lucene.grid.CartesianGridComputer;
import ru.ispras.modis.geo.lucene.grid.Cell;
import ru.ispras.modis.geo.lucene.util.FixedTokensCollectionStream;

public class CoordinatesIndexSearchUtil {
    private static final String COORD_SEPARATOR = "\t";
    private static final String FIELD_SEPARATOR = ":";
    private static final String[] empty = new String[0];
    private static final CartesianGridComputer gridComputer = new CartesianGridComputer();
    private static final ApproximatingRectanglesComputer boundComputer = new ApproximatingRectanglesComputer();

    public static Document addCoordinatesField(Document document, String string, Collection<Coordinate> collection) {
        Field field = new Field(string, CoordinatesIndexSearchUtil.getStringRepresentation(collection), Field.Store.YES, Field.Index.ANALYZED);
        field.setTokenStream((TokenStream)new FixedTokensCollectionStream(CoordinatesIndexSearchUtil.getCells(collection)));
        document.add((Fieldable)field);
        return document;
    }

    private static String getStringRepresentation(Collection<Coordinate> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Coordinate coordinate : collection) {
            stringBuilder.append(coordinate.getLatitude()).append(FIELD_SEPARATOR).append(coordinate.getLongitude()).append(COORD_SEPARATOR);
        }
        int n = stringBuilder.length();
        if (n >= COORD_SEPARATOR.length()) {
            stringBuilder.delete(n - COORD_SEPARATOR.length(), n);
        }
        return stringBuilder.toString();
    }

    private static String[] getCells(Collection<Coordinate> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Coordinate coordinate : collection) {
            List<Cell> list = gridComputer.computeCells(coordinate);
            hashSet.addAll(CoordinatesIndexSearchUtil.convertToStrings(list));
        }
        return new ArrayList(hashSet).toArray(empty);
    }

    private static List<String> convertToStrings(List<Cell> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (Cell cell : list) {
            arrayList.add(cell.toString());
        }
        return arrayList;
    }

    public static List<Coordinate> getCoordinatesFromDocument(Document document, String string) {
        String string2 = document.get(string);
        ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>();
        for (String string3 : string2.split(COORD_SEPARATOR)) {
            if (string3.isEmpty()) continue;
            String[] stringArray = string3.split(FIELD_SEPARATOR);
            double d = Double.parseDouble(stringArray[0]);
            double d2 = Double.parseDouble(stringArray[1]);
            arrayList.add(new Coordinate(d, d2));
        }
        return arrayList;
    }

    public static Query makeDistanceQuery(String string, Coordinate coordinate, double d, boolean bl) {
        return new ConstantScoreQuery(CoordinatesIndexSearchUtil.makeDistanceFilter(string, coordinate, d, bl));
    }

    public static Query makeDistanceQuery(String string, Coordinate coordinate, double d) {
        return CoordinatesIndexSearchUtil.makeDistanceQuery(string, coordinate, d, true);
    }

    public static Filter makeDistanceFilter(String string, Coordinate coordinate, double d, boolean bl) {
        Rectangle rectangle = boundComputer.getApproximatingRectangle(coordinate, d);
        int n = gridComputer.getBestLevel(d);
        List<Cell> list = gridComputer.computeCells(rectangle, n);
        List<String> list2 = CoordinatesIndexSearchUtil.convertToStrings(list);
        if (bl) {
            return new SingleFieldPreciseDistanceFilter(coordinate, d, list2.toArray(empty), string, string);
        }
        TermsFilter termsFilter = new TermsFilter();
        for (String string2 : list2) {
            termsFilter.addTerm(new Term(string, string2));
        }
        return termsFilter;
    }

    static class SingleFieldSelector
    implements FieldSelector {
        private static final long serialVersionUID = -305646696877649267L;
        private final String field;

        public SingleFieldSelector(String string) {
            this.field = string;
        }

        public FieldSelectorResult accept(String string) {
            return string.equals(this.field) ? FieldSelectorResult.LOAD : FieldSelectorResult.NO_LOAD;
        }
    }

    static class SingleFieldPreciseDistanceFilter
    extends PreciseDistanceFilter {
        private static final long serialVersionUID = 6948635353171397771L;
        private final String coordinatesFieldName;

        public SingleFieldPreciseDistanceFilter(Coordinate coordinate, double d, String[] stringArray, String string, String string2) {
            super(coordinate, d, stringArray, string);
            this.coordinatesFieldName = string2;
        }

        @Override
        protected Collection<Coordinate> getCoordinates(int n, IndexReader indexReader) throws IOException {
            Document document = indexReader.document(n, (FieldSelector)new SingleFieldSelector(this.coordinatesFieldName));
            return CoordinatesIndexSearchUtil.getCoordinatesFromDocument(document, this.cellsFieldName);
        }
    }
}

