/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.geo.lucene.grid;

public class Cell {
    private static final int[] masks = new int[33];
    private final int level;
    private final int x;
    private final int y;

    public Cell(int n, int n2, int n3) {
        this.level = n;
        this.x = n2;
        this.y = n3;
    }

    public int getY() {
        return this.y;
    }

    public int getX() {
        return this.x;
    }

    public int getLevel() {
        return this.level;
    }

    public Cell getLeftNeighbour() {
        return new Cell(this.level, this.getSmallerNumberNeighbour(this.x), this.y);
    }

    public Cell getBottomNeighbour() {
        return new Cell(this.level, this.x, this.getSmallerNumberNeighbour(this.y));
    }

    private int getSmallerNumberNeighbour(int n) {
        return n - 1 & masks[this.level];
    }

    public Cell getParentCell() {
        return new Cell(this.level - 1, this.x >> 1, this.y >> 1);
    }

    public String toString() {
        return this.level + ":" + this.x + "_" + this.y;
    }

    public int hashCode() {
        return this.level ^ this.x ^ this.y;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Cell) {
            Cell cell = (Cell)object;
            return this.level == cell.level && this.x == cell.x && this.y == cell.y;
        }
        return false;
    }

    static {
        Cell.masks[0] = 0;
        for (int i = 1; i < 33; ++i) {
            Cell.masks[i] = masks[i - 1] << 1 | 1;
        }
    }
}

