/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.geo.lucene;

import ru.ispras.modis.geo.Coordinate;

public class SpatialUtils {
    private static final double KILOMETRES_IN_MILE = 1.609344;
    private static final double EARTH_RADIUS_KM = 6371.009;
    private static final double METERS_IN_KILOMETER = 1000.0;
    public static final double RADIUS_EARTH_METERS = 6371009.0;
    public static final double CIRCUMFERENCE_EARTH_METERS = 4.0075E7;

    public static double milesToMeters(double d) {
        return SpatialUtils.milesToKilometers(d) * 1000.0;
    }

    public static double milesToKilometers(double d) {
        return d * 1.609344;
    }

    public static double kilometersToMiles(double d) {
        return d / 1.609344;
    }

    public static double metersToMiles(double d) {
        return SpatialUtils.kilometersToMiles(d / 1000.0);
    }

    public static double metersDistanceBetween(Coordinate coordinate, Coordinate coordinate2) {
        return SpatialUtils.computeMetersDistance(coordinate, coordinate2);
    }

    public static double kilometersDistanceBetween(Coordinate coordinate, Coordinate coordinate2) {
        return SpatialUtils.computeMetersDistance(coordinate, coordinate2) / 1000.0;
    }

    public static double milesDistanceBetween(Coordinate coordinate, Coordinate coordinate2) {
        return SpatialUtils.kilometersToMiles(SpatialUtils.kilometersDistanceBetween(coordinate, coordinate2));
    }

    private static double computeMetersDistance(Coordinate coordinate, Coordinate coordinate2) {
        double d = Math.toRadians(coordinate.getLongitude() - coordinate2.getLongitude());
        double d2 = Math.toRadians(coordinate.getLatitude());
        double d3 = Math.toRadians(coordinate2.getLatitude());
        double d4 = Math.sin(d2) * Math.sin(d3) + Math.cos(d2) * Math.cos(d3) * Math.cos(d);
        if (d4 <= -1.0) {
            return 2.0015115070354454E7;
        }
        if (d4 >= 1.0) {
            return 0.0;
        }
        return Math.acos(d4) * 6371009.0;
    }
}

