/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.geo.lucene;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.FixedBitSet;
import ru.ispras.modis.geo.Coordinate;
import ru.ispras.modis.geo.lucene.SpatialUtils;

public abstract class PreciseDistanceFilter
extends Filter {
    private static final long serialVersionUID = 6158164521820083207L;
    private Coordinate center;
    private double metersDistance;
    private String[] cellIds;
    protected String cellsFieldName;

    public PreciseDistanceFilter(Coordinate coordinate, double d, String[] stringArray, String string) {
        this.center = coordinate;
        this.metersDistance = d;
        this.cellIds = stringArray;
        this.cellsFieldName = string;
    }

    public DocIdSet getDocIdSet(IndexReader indexReader) throws IOException {
        FixedBitSet fixedBitSet = new FixedBitSet(indexReader.maxDoc());
        TermDocs termDocs = indexReader.termDocs();
        Term term = new Term(this.cellsFieldName);
        for (String string : this.cellIds) {
            Term term2 = term.createTerm(string);
            termDocs.seek(term2);
            while (termDocs.next()) {
                int n = termDocs.doc();
                if (!this.accept(n, indexReader)) continue;
                fixedBitSet.set(n);
            }
        }
        return fixedBitSet;
    }

    protected boolean accept(int n, IndexReader indexReader) throws IOException {
        Collection<Coordinate> collection = this.getCoordinates(n, indexReader);
        for (Coordinate coordinate : collection) {
            if (!(SpatialUtils.metersDistanceBetween(this.center, coordinate) <= this.metersDistance)) continue;
            return true;
        }
        return false;
    }

    protected abstract Collection<Coordinate> getCoordinates(int var1, IndexReader var2) throws IOException;
}

