/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.ne;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.Span;
import ru.ispras.texterra.core.nlp.annotators.IAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.IToken;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocumentHelper;
import ru.ispras.texterra.core.nlp.datamodel.Sentence;
import ru.ispras.texterra.core.nlp.datamodel.ne.INamedEntity;
import ru.ispras.texterra.core.nlp.datamodel.ne.NamedEntityToken;

public final class OpenNLPNETagger
implements IAnnotator<NamedEntityToken> {
    private final Map<INamedEntity, TokenNameFinderModel> models;

    public OpenNLPNETagger(Map<INamedEntity, TokenNameFinderModel> models) {
        this.models = new HashMap<INamedEntity, TokenNameFinderModel>(models);
    }

    public Collection<NamedEntityToken> annotate(INLPDocument document) {
        ArrayList<NamedEntityToken> result = new ArrayList<NamedEntityToken>();
        for (Map.Entry<INamedEntity, TokenNameFinderModel> entry : this.models.entrySet()) {
            INamedEntity entity = entry.getKey();
            NameFinderME tagger = new NameFinderME(entry.getValue());
            List sentences = document.getAnnotations(Sentence.class);
            for (Sentence sentence : sentences) {
                List sentenceTokens = NLPDocumentHelper.getContainedAnnotations((INLPDocument)document, (IAnnotation)sentence, IToken.class);
                ArrayList<Object> text = new ArrayList<Object>();
                for (IToken token : sentenceTokens) {
                    text.add(token.getValue());
                }
                String[] textArray = text.toArray(new String[text.size()]);
                Span[] nameSpans = tagger.find(textArray);
                for (int i = 0; i < nameSpans.length; ++i) {
                    int spanStart = ((IToken)sentenceTokens.get(nameSpans[i].getStart())).getStart();
                    int spanEnd = ((IToken)sentenceTokens.get(nameSpans[i].getEnd() - 1)).getEnd();
                    result.add(new NamedEntityToken(document.getText(), spanStart, spanEnd, entity));
                }
            }
            tagger.clearAdaptiveData();
        }
        return result;
    }
}

