/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.tools.nlp.representation;

import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import ru.ispras.texterra.core.ekb.interfaces.IRepresentation;
import ru.ispras.texterra.core.ekb.interfaces.TexterraKBM;
import ru.ispras.texterra.core.ekb.representation.TermCandidate;
import ru.ispras.texterra.core.nlp.annotators.CoincidingAnnotator;
import ru.ispras.texterra.core.nlp.annotators.IAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.IValuedAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocumentHelper;
import ru.ispras.texterra.tools.nlp.datamodel.NLPDocumentOptions;
import ru.ispras.texterra.tools.nlp.kbm.KBMAnnotation;
import ru.ispras.texterra.tools.nlp.pipelines.graph.IPipelineNodeProvider;
import ru.ispras.texterra.tools.nlp.pipelines.graph.PipelineNode;
import ru.ispras.texterra.tools.nlp.pipelines.graph.PipelineNodeDependencies;

public class RepresentationFeatureProvider<F extends IAnnotation>
implements IPipelineNodeProvider<F, IAnnotator<F>>,
Serializable {
    private static final long serialVersionUID = -2242474101051259920L;
    private final Class<? extends IAnnotation> termAnnotationType;
    private final Class<F> featureType;

    public RepresentationFeatureProvider(Class<? extends IAnnotation> termAnnotationType, Class<F> featureType) {
        this.termAnnotationType = (Class)Validate.notNull(termAnnotationType);
        this.featureType = (Class)Validate.notNull(featureType);
    }

    @Override
    public PipelineNode<F, IAnnotator<F>> get(NLPDocumentOptions options) {
        IRepresentation representation = ((TexterraKBM)options.getOption(KBMAnnotation.class)).getRepresentation();
        return new PipelineNode(new PipelineNodeDependencies().withSoftImplicitDependencies(KBMAnnotation.class).withSoftImplicitDependencies(representation.getRequiredInputs()).withHardDependencies(new PipelineNode(new PipelineNodeDependencies().withSoftImplicitDependencies(this.termAnnotationType), new CoincidingAnnotator(this.termAnnotationType, TermCandidate::new))), new RepresentationFeatureAnnotator<F>(this.featureType));
    }

    @Override
    public Set<Class<? extends IValuedAnnotation<?>>> getRequiredOptions() {
        return ImmutableSet.of(KBMAnnotation.class);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.featureType.hashCode();
        result = 31 * result + this.termAnnotationType.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof RepresentationFeatureProvider)) {
            return false;
        }
        RepresentationFeatureProvider other = (RepresentationFeatureProvider)obj;
        return this.featureType.equals(other.featureType) && this.termAnnotationType.equals(other.termAnnotationType);
    }

    public static final class RepresentationFeatureAnnotator<F extends IAnnotation>
    implements IAnnotator<F>,
    Serializable {
        private static final long serialVersionUID = 8383236972394941470L;
        private final Class<F> featureType;

        public RepresentationFeatureAnnotator(Class<F> featureType) {
            this.featureType = (Class)Validate.notNull(featureType);
        }

        public Collection<F> annotate(INLPDocument doc) {
            IRepresentation representation = ((TexterraKBM)((KBMAnnotation)NLPDocumentHelper.getAnnotation((INLPDocument)doc, KBMAnnotation.class)).getValue()).getRepresentation();
            return representation.getTerms(doc, new Class[]{this.featureType}).getAnnotations(this.featureType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.featureType == null ? 0 : this.featureType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof RepresentationFeatureAnnotator)) {
                return false;
            }
            RepresentationFeatureAnnotator other = (RepresentationFeatureAnnotator)obj;
            return this.featureType.equals(other.featureType);
        }
    }
}

