/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.tools.nlp.pipelines.graph;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import ru.ispras.texterra.core.nlp.annotators.IAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.tools.nlp.pipelines.graph.CompiledGraphPipeline;
import ru.ispras.texterra.tools.nlp.pipelines.graph.GraphPipelineNode;

class PipelineComputer {
    private final INLPDocument doc;
    private final Map<GraphPipelineNode<?, ?>, Collection<? extends IAnnotation>> computationalCache;

    public PipelineComputer(INLPDocument doc) {
        this.doc = doc;
        this.computationalCache = new HashMap();
    }

    public <A extends IAnnotation> Collection<A> compute(CompiledGraphPipeline<A> compiledPipeline) {
        Map<GraphPipelineNode<?, ?>, Set<GraphPipelineNode<?, ?>>> unresolvedDependencies = this.removeCached(compiledPipeline.getDependencies());
        Set<GraphPipelineNode<?, ?>> targetNodeBlockers = unresolvedDependencies.get(compiledPipeline.getTarget());
        if (targetNodeBlockers == null) {
            Collection<? extends IAnnotation> result = this.computationalCache.get(compiledPipeline.getTarget());
            return result;
        }
        while (!targetNodeBlockers.isEmpty()) {
            Collection<GraphPipelineNode<?, ?>> unblockedNodes = this.getUnblockedNodes(unresolvedDependencies);
            for (GraphPipelineNode<?, ?> pipelineNode : unblockedNodes) {
                this.computeNode(pipelineNode);
                this.resolve(unresolvedDependencies, pipelineNode);
            }
        }
        return this.computeNode(compiledPipeline.getTarget());
    }

    private Collection<GraphPipelineNode<?, ?>> getUnblockedNodes(Map<GraphPipelineNode<?, ?>, Set<GraphPipelineNode<?, ?>>> compiledPipeline) {
        HashSet result = new HashSet();
        for (Map.Entry<GraphPipelineNode<?, ?>, Set<GraphPipelineNode<?, ?>>> entry : compiledPipeline.entrySet()) {
            if (!entry.getValue().isEmpty()) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    private <A extends IAnnotation> Collection<A> computeNode(GraphPipelineNode<A, ? extends IAnnotator<A>> pipelineNode) {
        INLPDocument doc = pipelineNode.getDocumentPretreatmentPipeline().traverse(this.doc);
        for (GraphPipelineNode<?, ?> childNode : pipelineNode.getDependencies()) {
            Collection<? extends IAnnotation> cached = this.computationalCache.get(childNode);
            Validate.notNull(cached);
            doc = doc.withAnnotations(cached);
        }
        Collection nodeResult = pipelineNode.getAnnotator().annotate(doc);
        this.computationalCache.put(pipelineNode, nodeResult);
        return nodeResult;
    }

    private void resolve(Map<GraphPipelineNode<?, ?>, Set<GraphPipelineNode<?, ?>>> compiledPipeline, GraphPipelineNode<?, ?> justComputed) {
        compiledPipeline.remove(justComputed);
        for (Map.Entry<GraphPipelineNode<?, ?>, Set<GraphPipelineNode<?, ?>>> entry : compiledPipeline.entrySet()) {
            entry.getValue().remove(justComputed);
        }
    }

    private Map<GraphPipelineNode<?, ?>, Set<GraphPipelineNode<?, ?>>> removeCached(Map<GraphPipelineNode<?, ?>, Set<GraphPipelineNode<?, ?>>> compiledPipeline) {
        HashMap result = new HashMap(compiledPipeline.size());
        Set<GraphPipelineNode<?, ?>> cached = this.computationalCache.keySet();
        for (Map.Entry<GraphPipelineNode<?, ?>, Set<GraphPipelineNode<?, ?>>> entry : compiledPipeline.entrySet()) {
            GraphPipelineNode<?, ?> key = entry.getKey();
            if (cached.contains(key)) continue;
            HashSet dependencies = new HashSet(entry.getValue());
            dependencies.removeAll(cached);
            result.put(entry.getKey(), dependencies);
        }
        return result;
    }
}

